<div class="row mb-4">
    <div class="col-md-12">
        <h2><i class="fas fa-server me-2"></i> Server Management</h2>
        <p class="text-muted">Monitoring traffic dan kontrol akses server ujian.</p>
    </div>
</div>

<div class="row">
    <!-- Active Users Card -->
    <div class="col-md-6 mb-4">
        <div class="card shadow border-left-primary py-2 h-100">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Pengguna Aktif (Realtime)</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800 display-4"><?php echo $data['active_users']; ?></div>
                        <small class="text-muted"><i class="fas fa-clock"></i> Dalam 5 menit terakhir</small>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-4x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Server Status Card -->
    <div class="col-md-6 mb-4">
        <div class="card shadow border-left-<?php echo ($data['maintenance_mode'] === '1') ? 'danger' : 'success'; ?> py-2 h-100">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-<?php echo ($data['maintenance_mode'] === '1') ? 'danger' : 'success'; ?> text-uppercase mb-1">Status Server</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                             <?php if($data['maintenance_mode'] === '1'): ?>
                                <span class="text-danger"><i class="fas fa-exclamation-triangle"></i> MAINTENANCE MODE</span>
                             <?php else: ?>
                                <span class="text-success"><i class="fas fa-check-circle"></i> ONLINE</span>
                             <?php endif; ?>
                        </div>
                        <small class="text-muted">Kapasitas: <?php echo $data['max_users']; ?> User</small>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-network-wired fa-4x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Active Users Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3 bg-white d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary"><i class="fas fa-users-cog"></i> Daftar Pengguna Aktif (Login < 5 Menit Terakhir)</h6>
        <button onclick="window.location.reload()" class="btn btn-sm btn-outline-primary"><i class="fas fa-sync"></i> Refresh</button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Username</th>
                        <th>Nama Lengkap</th>
                        <th>Role / Kelas</th>
                        <th>Status Akun</th>
                        <th>Login Terakhir</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($data['active_users_list'])): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">Tidak ada pengguna aktif saat ini.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($data['active_users_list'] as $user): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($user->username); ?></td>
                                <td><?php echo htmlspecialchars($user->name); ?></td>
                                <td>
                                    <span class="badge bg-secondary"><?php echo ucfirst($user->role); ?></span>
                                    <?php if($user->class_name) echo '<span class="badge bg-info">' . htmlspecialchars($user->class_name) . '</span>'; ?>
                                </td>
                                <td>
                                    <?php 
                                        if ($user->status_akun == 'active') echo '<span class="badge bg-success">Active</span>';
                                        elseif ($user->status_akun == 'suspended') {
                                            echo '<span class="badge bg-warning text-dark">Suspended</span>';
                                            if($user->suspended_until) echo '<br><small class="text-danger">' . date('H:i', strtotime($user->suspended_until)) . '</small>';
                                        }
                                        else echo '<span class="badge bg-danger">Banned</span>';
                                    ?>
                                </td>
                                <td><?php echo date('H:i:s', strtotime($user->last_active)); ?></td>
                                <td>
                                    <?php if($user->status_akun != 'suspended'): ?>
                                        <button class="btn btn-sm btn-warning" onclick="showSuspendModal('<?php echo $user->id; ?>', '<?php echo htmlspecialchars($user->name); ?>')">
                                            <i class="fas fa-pause-circle"></i> Suspend
                                        </button>
                                    <?php else: ?>
                                        <form action="<?php echo BASE_URL; ?>admin/unsuspend_user" method="POST" class="d-inline">
                                            <input type="hidden" name="user_id" value="<?php echo $user->id; ?>">
                                            <button type="submit" class="btn btn-sm btn-success">
                                                <i class="fas fa-play-circle"></i> Unsuspend
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Suspend Modal -->
<div class="modal fade" id="suspendModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo BASE_URL; ?>admin/suspend_user" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Suspend User Sementara</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="user_id" id="suspendUserId">
                    <p>Pilih durasi suspend untuk user <strong id="suspendUserName"></strong>:</p>
                    <div class="list-group">
                        <label class="list-group-item">
                            <input class="form-check-input me-1" type="radio" name="minutes" value="5" checked>
                            5 Menit
                        </label>
                        <label class="list-group-item">
                            <input class="form-check-input me-1" type="radio" name="minutes" value="15">
                            15 Menit
                        </label>
                        <label class="list-group-item">
                            <input class="form-check-input me-1" type="radio" name="minutes" value="60">
                            1 Jam
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-warning">Suspend User</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function showSuspendModal(id, name) {
        document.getElementById('suspendUserId').value = id;
        document.getElementById('suspendUserName').textContent = name;
        new bootstrap.Modal(document.getElementById('suspendModal')).show();
    }
</script>

<!-- Configuration Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3 bg-white">
        <h6 class="m-0 font-weight-bold text-primary"><i class="fas fa-cogs"></i> Konfigurasi Traffic & Akses</h6>
    </div>
    <div class="card-body">
        <form action="<?php echo BASE_URL; ?>admin/update_server_config" method="POST">
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Batas Maksimal User (Concurrent)</label>
                    <input type="number" name="max_concurrent_users" class="form-control form-control-lg" value="<?php echo $data['max_users']; ?>" required min="1">
                    <small class="text-muted">Jika pengguna aktif melebihi angka ini, pengguna baru akan diblokir sementara.</small>
                </div>
                
                <div class="col-md-6">
                    <label class="form-label fw-bold">Mode Pemeliharaan (Maintenance)</label>
                    <div class="form-check form-switch p-3 border rounded bg-light">
                        <input class="form-check-input" type="checkbox" id="maintenanceSwitch" name="maintenance_mode" value="1" <?php echo ($data['maintenance_mode'] === '1') ? 'checked' : ''; ?> style="width: 3em; height: 1.5em; margin-right: 1em;">
                        <label class="form-check-label pt-1" for="maintenanceSwitch">Aktifkan Maintenance Mode</label>
                    </div>
                     <small class="text-danger mt-2 d-block">* Jika aktif, hanya Admin yang bisa mengakses sistem.</small>
                </div>
            </div>

            <div class="mb-4">
                <label class="form-label fw-bold">Pesan Server</label>
                <textarea name="server_message" class="form-control" rows="3"><?php echo $data['server_message']; ?></textarea>
                <small class="text-muted">Pesan ini akan muncul saat user ditolak aksesnya (Maintenance/Penuh).</small>
            </div>

            <hr>
            
            <button type="submit" class="btn btn-primary px-5"><i class="fas fa-save me-2"></i> Simpan Konfigurasi</button>
        </form>
    </div>
</div>

<script>
    // Simple Auto-Refresh for Active Users Count
    setInterval(() => {
        // Ideally fetch via AJAX, but full reload is safer for Admin stats for now
        // or just leave it manual
    }, 60000);
</script>
