<div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Kelola Mata Pelajaran</h2>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSubjectModal">
        <i class="fas fa-plus"></i> Tambah Mapel
    </button>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width: 50px;">No</th>
                        <th>Nama Mata Pelajaran</th>
                        <th style="width: 150px;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($data['subjects'])): ?>
                        <tr><td colspan="3" class="text-center">Belum ada mata pelajaran.</td></tr>
                    <?php else: ?>
                        <?php $no = 1; foreach($data['subjects'] as $subject): ?>
                            <tr>
                                <td><?php echo $no++; ?></td>
                                <td><?php echo $subject->name; ?></td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>subject/delete/<?php echo $subject->id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin hapus mapel ini?');"><i class="fas fa-trash"></i> Hapus</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Tambah Mapel -->
<div class="modal fade" id="addSubjectModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo BASE_URL; ?>subject/store" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Mata Pelajaran</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nama Mata Pelajaran</label>
                        <input type="text" name="name" class="form-control" required placeholder="Contoh: Matematika, Bahasa Indonesia">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
