<div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Kelola Pengguna</h2>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal">
        <i class="fas fa-plus"></i> Tambah Pengguna
    </button>
</div>

<!-- Filter & Search Card -->
<div class="card mb-3 shadow-sm border-0 bg-white">
    <div class="card-body py-3">
        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label small fw-bold text-secondary mb-1">Pencarian</label>
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-light border-end-0"><i class="fas fa-search text-muted"></i></span>
                    <input type="text" id="searchInput" class="form-control border-start-0 bg-light" placeholder="Cari Nama atau Username...">
                </div>
            </div>
            <div class="col-md-3">
                <label class="form-label small fw-bold text-secondary mb-1">Filter Peran</label>
                <select id="roleFilter" class="form-select form-select-sm bg-light">
                    <option value="">Semua Peran</option>
                    <option value="Siswa">Siswa</option>
                    <option value="Guru">Guru</option>
                    <option value="Admin">Admin</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label small fw-bold text-secondary mb-1">Filter Kelas</label>
                <select id="classFilter" class="form-select form-select-sm bg-light">
                    <option value="">Semua Kelas</option>
                        <?php foreach($data['classes'] as $cls): ?>
                        <option value="<?php echo $cls->name; ?>"><?php echo $cls->name; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-sm btn-outline-secondary w-100" onclick="resetFilters()">
                    <i class="fas fa-sync-alt me-1"></i> Reset
                </button>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Username</th>
                        <th>Nama Lengkap</th>
                        <th>Peran</th>
                        <th>Kelas</th>
                        <th>Status/Aktivitas</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($data['users'])): ?>
                         <tr><td colspan="5" class="text-center">Tidak ada pengguna ditemukan.</td></tr>
                    <?php else: ?>
                        <?php foreach($data['users'] as $user): ?>
                            <tr>
                                <td><?php echo $user->username; ?></td>
                                <td><?php echo $user->name; ?></td>
                                <td><span class="badge bg-<?php echo ($user->role == 'admin') ? 'danger' : (($user->role == 'guru') ? 'warning' : 'info'); ?>"><?php echo ucfirst($user->role); ?></span></td>
                                <td><?php echo $user->class_name ?? '-'; ?></td>
                                <td>
                                    <?php if($user->is_online): ?>
                                        <span class="badge bg-success rounded-pill" title="Online">&bull; On</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary rounded-pill" title="Offline">&bull; Off</span>
                                    <?php endif; ?>

                                    <?php if($user->role == 'siswa'): ?>
                                        <br>
                                        <?php if($user->active_session_id): ?>
                                             <small class="text-primary fw-bold">
                                                 <i class="fas fa-pen"></i> Soal <?php echo $user->answered_count; ?> / <?php echo $user->total_questions; ?>
                                             </small>
                                        <?php elseif($user->banned_count > 0): ?>
                                             <small class="text-danger fw-bold"><i class="fas fa-ban"></i> Terblokir</small>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($user->role == 'siswa' && $user->banned_count > 0): ?>
                                        <a href="<?php echo BASE_URL; ?>admin/reset_exam/<?php echo $user->id; ?>" class="btn btn-sm btn-info text-white" onclick="return confirm('Reset blokir ujian aktif untuk pengguna ini?');" title="Buka Blokir Sesi Ujian"><i class="fas fa-unlock"></i></a>
                                    <?php endif; ?>
                                    <?php if($user->role != 'admin'): ?>
                                        <button onclick="editUser(<?php echo $user->id; ?>)" class="btn btn-sm btn-warning text-white"><i class="fas fa-edit"></i></button>
                                        <a href="<?php echo BASE_URL; ?>admin/delete_user/<?php echo $user->id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Hapus pengguna?');"><i class="fas fa-trash"></i></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Tambah User -->
<div class="modal fade" id="addUserModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="<?php echo BASE_URL; ?>admin/store_user" method="POST" enctype="multipart/form-data" id="addUserForm" class="needs-validation" novalidate>
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Pengguna Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Role Selection First -->
                    <div class="mb-3">
                        <label class="form-label">Peran <span class="text-danger">*</span></label>
                        <select name="role" class="form-select" id="roleSelect" required onchange="toggleBiodata()">
                            <option value="siswa">Siswa</option>
                            <option value="guru">Guru</option>
                            <option value="admin">Admin</option>
                        </select>
                        <div class="invalid-feedback">Pilih peran pengguna</div>
                    </div>
                    
                    <hr>
                    
                    <!-- Biodata Section for Siswa -->
                    <div id="biodataSection">
                        <h6 class="text-primary mb-3"><i class="fas fa-user-graduate"></i> Data Siswa</h6>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">NISN <span class="text-danger">*</span></label>
                                <input type="text" name="nisn" id="nisn_input" class="form-control" placeholder="Nomor Induk Siswa Nasional" required>
                                <small class="text-muted">NISN akan digunakan sebagai username</small>
                                <div class="invalid-feedback">NISN wajib diisi</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                                <input type="text" name="name" id="name_siswa" class="form-control" required>
                                <div class="invalid-feedback">Nama wajib diisi</div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tempat Lahir</label>
                                <input type="text" name="tempat_lahir" class="form-control" placeholder="Kota/Kabupaten">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tanggal Lahir</label>
                                <input type="date" name="tanggal_lahir" class="form-control">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Jenis Kelamin</label>
                                <select name="jenis_kelamin" class="form-select">
                                    <option value="">-- Pilih --</option>
                                    <option value="L">Laki-laki</option>
                                    <option value="P">Perempuan</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Kelas <span class="text-danger">*</span></label>
                                <select name="class_id" id="kelasSelect" class="form-select" required>
                                    <option value="">-- Pilih Kelas --</option>
                                    <?php foreach($data['classes'] as $cls): ?>
                                        <option value="<?php echo $cls->id; ?>"><?php echo $cls->name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <div class="invalid-feedback">Kelas wajib dipilih</div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Alamat Lengkap</label>
                            <textarea name="alamat" class="form-control" rows="2" placeholder="Jalan, RT/RW, Kelurahan, Kecamatan"></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nomor Telepon/HP</label>
                                <input type="text" name="telepon" class="form-control" placeholder="08xxxxxxxxxx">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Foto Siswa (Opsional)</label>
                                <input type="file" name="foto" class="form-control" accept="image/*">
                                <small class="text-muted">Format: JPG, PNG (Max 2MB)</small>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Basic Fields for Non-Siswa -->
                    <div id="basicSection" style="display:none;">
                        <h6 class="text-primary mb-3"><i class="fas fa-user"></i> Data Pengguna</h6>
                        <div class="mb-3">
                            <label class="form-label">Username (NIS/NIP) <span class="text-danger">*</span></label>
                            <input type="text" name="username_basic" id="username_basic" class="form-control">
                            <div class="invalid-feedback">Username wajib diisi</div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" name="name_basic" id="name_basic" class="form-control">
                            <div class="invalid-feedback">Nama wajib diisi</div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <!-- Password Section -->
                    <div class="mb-3">
                        <label class="form-label">Password <span class="text-danger">*</span></label>
                        <input type="password" name="password" id="password_input" class="form-control" required placeholder="Minimal 6 karakter" minlength="6">
                        <div class="invalid-feedback">Password wajib diisi (minimal 6 karakter)</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

</script>

<!-- Modal Edit User -->
<div class="modal fade" id="editUserModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="<?php echo BASE_URL; ?>admin/update_user" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="id" id="edit_id">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Pengguna</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Username (NIS/NIP)</label>
                            <input type="text" name="username" id="edit_username" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nama Lengkap</label>
                            <input type="text" name="name" id="edit_name" class="form-control" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Password (Kosongkan jika tidak diubah)</label>
                        <input type="password" name="password" class="form-control" placeholder="Isi untuk ganti password">
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Peran</label>
                            <select name="role" class="form-select" id="edit_roleSelect" required onchange="toggleKelasEdit()">
                                <option value="siswa">Siswa</option>
                                <option value="guru">Guru</option>
                                <option value="admin">Admin</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3" id="edit_kelasContainer">
                            <label class="form-label">Kelas (Wajib untuk Siswa)</label>
                            <select name="class_id" id="edit_class_id" class="form-select">
                                <option value="">-- Pilih Kelas --</option>
                                <?php foreach($data['classes'] as $cls): ?>
                                    <option value="<?php echo $cls->id; ?>"><?php echo $cls->name; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Biodata Section for Edit -->
                    <div id="edit_biodataSection" style="display:none; border-top: 1px solid #dee2e6; padding-top: 15px; margin-top: 10px;">
                        <h6 class="text-primary mb-3"><i class="fas fa-user-edit"></i> Edit Biodata Siswa</h6>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tempat Lahir</label>
                                <input type="text" name="tempat_lahir" id="edit_tempat_lahir" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Tanggal Lahir</label>
                                <input type="date" name="tanggal_lahir" id="edit_tanggal_lahir" class="form-control">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Jenis Kelamin</label>
                                <select name="jenis_kelamin" id="edit_jenis_kelamin" class="form-select">
                                    <option value="">-- Pilih --</option>
                                    <option value="L">Laki-laki</option>
                                    <option value="P">Perempuan</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nomor Telepon</label>
                                <input type="text" name="telepon" id="edit_telepon" class="form-control">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Alamat</label>
                            <textarea name="alamat" id="edit_alamat" class="form-control" rows="2"></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Update Foto (Biarkan kosong jika tidak diganti)</label>
                            <input type="file" name="foto" class="form-control" accept="image/*">
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleBiodata() {
    var role = document.getElementById('roleSelect').value;
    var biodataSection = document.getElementById('biodataSection');
    var basicSection = document.getElementById('basicSection');
    
    // Get form fields
    var nisnInput = document.getElementById('nisn_input');
    var nameSiswa = document.getElementById('name_siswa');
    var kelasSelect = document.getElementById('kelasSelect');
    var usernameBasic = document.getElementById('username_basic');
    var nameBasic = document.getElementById('name_basic');
    
    if (role === 'siswa') {
        // Show biodata section for siswa
        biodataSection.style.display = 'block';
        basicSection.style.display = 'none';
        
        // Set required for siswa fields
        if(nisnInput) nisnInput.required = true;
        if(nameSiswa) nameSiswa.required = true;
        if(kelasSelect) kelasSelect.required = true;
        
        // Remove required from basic fields
        if(usernameBasic) usernameBasic.required = false;
        if(nameBasic) nameBasic.required = false;
    } else {
        // Show basic section for guru/admin
        biodataSection.style.display = 'none';
        basicSection.style.display = 'block';
        
        // Remove required from siswa fields
        if(nisnInput) nisnInput.required = false;
        if(nameSiswa) nameSiswa.required = false;
        if(kelasSelect) kelasSelect.required = false;
        
        // Set required for basic fields
        if(usernameBasic) usernameBasic.required = true;
        if(nameBasic) nameBasic.required = true;
    }
}

function toggleKelas() {
    toggleBiodata(); // Re-use for compatibility
}

function toggleKelasEdit() {
    var role = document.getElementById('edit_roleSelect').value;
    var kelasDiv = document.getElementById('edit_kelasContainer');
    var biodataDiv = document.getElementById('edit_biodataSection');

    if (role === 'siswa') {
        kelasDiv.style.display = 'block';
        biodataDiv.style.display = 'block';
    } else {
        kelasDiv.style.display = 'none';
        biodataDiv.style.display = 'none';
        kelasDiv.querySelector('select').value = '';
    }
}

function editUser(id) {
    // Fetch User Data
    fetch('<?php echo BASE_URL; ?>admin/get_user_json/' + id)
    .then(response => response.json())
    .then(data => {
        document.getElementById('edit_id').value = data.id;
        document.getElementById('edit_username').value = data.username;
        document.getElementById('edit_name').value = data.name;
        document.getElementById('edit_roleSelect').value = data.role;
        document.getElementById('edit_class_id').value = data.class_id;
        
        // Populate Biodata Fields
        document.getElementById('edit_tempat_lahir').value = data.tempat_lahir || '';
        document.getElementById('edit_tanggal_lahir').value = data.tanggal_lahir || '';
        document.getElementById('edit_jenis_kelamin').value = data.jenis_kelamin || '';
        document.getElementById('edit_telepon').value = data.telepon || '';
        document.getElementById('edit_alamat').value = data.alamat || '';
        
        toggleKelasEdit();
        
        var editModal = new bootstrap.Modal(document.getElementById('editUserModal'));
        editModal.show();
    });
}

// Bootstrap 5 Form Validation
(function () {
    'use strict';

    // Fetch the form we want to apply custom Bootstrap validation styles to
    var form = document.getElementById('addUserForm');
    
    if (form) {
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            
            form.classList.add('was-validated');
        }, false);
    }
})();

// Init
// Client-side Filtering Logic
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const roleFilter = document.getElementById('roleFilter');
    const classFilter = document.getElementById('classFilter');
    
    // Get all rows from the table body (excluding the "not found" row if any)
    const tableBody = document.querySelector('table tbody');
    const originalRows = Array.from(tableBody.querySelectorAll('tr')); // Store reference

    function filterTable() {
        const searchTerm = searchInput.value.toLowerCase();
        const roleTerm = roleFilter.value.toLowerCase();
        const classTerm = classFilter.value.toLowerCase();

        originalRows.forEach(row => {
            // Check if it's the "No users found" message row
            if (row.cells.length === 1) return; 

            // Columns: 0=Username, 1=Name, 2=Role, 3=Class
            const username = row.cells[0]?.innerText.toLowerCase() || '';
            const name = row.cells[1]?.innerText.toLowerCase() || '';
            const role = row.cells[2]?.innerText.toLowerCase() || '';
            const className = row.cells[3]?.innerText.toLowerCase() || '';

            const matchesSearch = username.includes(searchTerm) || name.includes(searchTerm);
            // Role check: Exact match preferred given short strings, but includes works if clean
            const matchesRole = roleTerm === '' || role.includes(roleTerm);
            // Class check: Includes because className might have spaces/formatting
            const matchesClass = classTerm === '' || className.includes(classTerm);

            if (matchesSearch && matchesRole && matchesClass) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    }

    searchInput.addEventListener('input', filterTable);
    roleFilter.addEventListener('change', filterTable);
    classFilter.addEventListener('change', filterTable);
    
    window.resetFilters = function() {
        searchInput.value = '';
        roleFilter.value = '';
        classFilter.value = '';
        filterTable();
    }
});

toggleBiodata();
</script>
