<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Masuk - E-Ujian</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f0f2f5;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .main-content {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-card {
            width: 100%;
            max-width: 400px;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            background: white;
        }
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        .login-header img {
            max-width: 80px;
            margin-bottom: 1rem;
            border-radius: 10px;
        }
        .login-header h3 {
            color: #333;
            font-weight: 700;
            font-size: 1.5rem;
        }
    </style>
</head>
<body>
    <?php
    // Fetch school settings for login page
    require_once '../app/models/SchoolSettings.php';
    // Database is already required in index.php -> Controller -> but SchoolSettings needs it.
    // SchoolSettings constructs Database inside.
    $schoolSettingsModel = new SchoolSettings();
    $schoolSettings = $schoolSettingsModel->getAllSettings();
    $schoolName = $schoolSettings['school_name'] ?? 'E-Ujian Sekolah';
    $schoolLogo = $schoolSettings['school_logo'] ?? null;
    ?>
    <div class="main-content">
        <div class="login-card">
        <div class="login-header">
            <?php if ($schoolLogo): ?>
                <img src="<?php echo BASE_URL; ?>uploads/school/<?php echo $schoolLogo; ?>" alt="Logo Sekolah">
            <?php else: ?>
                <div class="mb-3">
                    <i class="fas fa-graduation-cap fa-4x text-primary"></i>
                </div>
            <?php endif; ?>
            <h3><?php echo $schoolName; ?></h3>
            <p class="text-muted">Masuk untuk memulai sesi Anda</p>
        </div>
        <form action="<?php echo BASE_URL; ?>auth/login" method="POST">
            <div class="mb-3">
                <label for="username" class="form-label">Nama Pengguna</label>
                <input type="text" class="form-control <?php echo (!empty($data['username_err'])) ? 'is-invalid' : ''; ?>" id="username" name="username" value="<?php echo isset($data['username']) ? $data['username'] : ''; ?>">
                <div class="invalid-feedback"><?php echo isset($data['username_err']) ? $data['username_err'] : ''; ?></div>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Kata Sandi</label>
                <div class="input-group">
                    <input type="password" class="form-control <?php echo (!empty($data['password_err'])) ? 'is-invalid' : ''; ?>" id="password" name="password" value="<?php echo isset($data['password']) ? $data['password'] : ''; ?>">
                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                        <i class="fas fa-eye" id="toggleIcon"></i>
                    </button>
                    <div class="invalid-feedback"><?php echo isset($data['password_err']) ? $data['password_err'] : ''; ?></div>
                </div>
            </div>
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary">Masuk</button>
            </div>
        </form>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer py-3 bg-white shadow-sm border-top" style="background-color: rgba(255, 255, 255, 0.85) !important; backdrop-filter: blur(5px); width: 100%;">
        <div class="container">
            <div class="row align-items-center justify-content-between">
                <div class="col-md-6 text-center text-md-start mb-2 mb-md-0">
                    <div class="small fw-bold text-muted">
                        <span>Dibuat oleh <a href="#" class="text-primary text-decoration-none">MH Studios</a> &copy; <?php echo date('Y'); ?></span>
                    </div>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <div class="d-inline-flex align-items-center gap-3">
                        <span class="small text-muted me-2">Ikuti Kami:</span>
                        <a href="https://www.youtube.com/@mhstudios4500" target="_blank" class="text-danger text-decoration-none" title="YouTube"><i class="fab fa-youtube fa-lg"></i></a>
                        <a href="https://www.instagram.com/maulanamalik_h12?igsh=MXh6OGo5a2Zwejkz" target="_blank" class="text-danger text-decoration-none" title="Instagram"><i class="fab fa-instagram fa-lg"></i></a>
                        <a href="https://wa.me/6285266789295" target="_blank" class="text-success text-decoration-none" title="WhatsApp"><i class="fab fa-whatsapp fa-lg"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle password visibility
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');
        const toggleIcon = document.getElementById('toggleIcon');

        togglePassword.addEventListener('click', function() {
            // Toggle the type attribute
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            // Toggle the icon
            if (type === 'password') {
                toggleIcon.classList.remove('fa-eye-slash');
                toggleIcon.classList.add('fa-eye');
            } else {
                toggleIcon.classList.remove('fa-eye');
                toggleIcon.classList.add('fa-eye-slash');
            }
        });
    </script>
</body>
</html>
