<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $data['title']; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background-color: #f8f9fc; height: 100vh; display: flex; align-items: center; justify-content: center; }
        .error-card { max-width: 500px; text-align: center; padding: 40px; border-radius: 15px; background: white; box-shadow: 0 10px 25px rgba(0,0,0,0.1); }
        .icon-box { font-size: 80px; color: #dc3545; margin-bottom: 20px; }
    </style>
</head>
<body>
    <div class="error-card">
        <div class="icon-box">
            <i class="fas fa-exclamation-circle"></i>
        </div>
        <h2 class="fw-bold text-dark mb-3"><?php echo $data['title']; ?></h2>
        <p class="text-muted lead mb-4"><?php echo $data['message']; ?></p>
        <a href="<?php echo BASE_URL; ?>" class="btn btn-primary px-4 rounded-pill"><i class="fas fa-home me-2"></i> Kembali ke Beranda</a>
    </div>
</body>
</html>
