<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Bank Soal Saya</h1>
    <a href="<?php echo BASE_URL; ?>guru/create_exam" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i class="fas fa-plus fa-sm text-white-50"></i> Tambah via Ujian Baru</a>
</div>

<!-- Info & Workflow Box -->
<div class="alert alert-light border shadow-sm mb-4" role="alert" style="border-left: 5px solid #1cc88a !important;">
    <div class="d-flex align-items-start">
        <div class="me-3 mt-1">
            <i class="fas fa-database fa-2x text-success"></i>
        </div>
        <div class="w-100">
            <h5 class="alert-heading fw-bold text-success mb-2">Tentang Bank Soal</h5>
            <p class="mb-3 text-secondary" style="line-height: 1.5;">
                Halaman ini adalah <strong>arsip lengkap</strong> dari seluruh soal yang pernah Anda buat di berbagai ujian. 
                Gunakan halaman ini untuk memeriksa koleksi soal Anda berdasarkan Mata Pelajaran atau Kelas.
            </p>
            
            <div class="bg-white p-3 rounded border">
                <h6 class="fw-bold small text-uppercase text-dark mb-3 border-bottom pb-2">Alur Pengisian Bank Soal</h6>
                <div class="d-flex flex-wrap align-items-center text-secondary small">
                    <div class="d-flex align-items-center mb-2 me-4">
                        <span class="badge bg-primary rounded-circle me-2">1</span>
                        <span>Buat <strong>Ujian Baru</strong></span>
                    </div>
                    <div class="d-none d-md-block text-muted me-4 mb-2"><i class="fas fa-chevron-right"></i></div>
                    <div class="d-flex align-items-center mb-2 me-4">
                        <span class="badge bg-primary rounded-circle me-2">2</span>
                        <span>Input <strong>Butir Soal</strong></span>
                    </div>
                    <div class="d-none d-md-block text-muted me-4 mb-2"><i class="fas fa-chevron-right"></i></div>
                    <div class="d-flex align-items-center mb-2">
                        <span class="badge bg-success rounded-circle me-2">3</span>
                        <span>Otomatis Masuk <strong>Bank Soal</strong></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Daftar Semua Soal</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Mata Pelajaran</th>
                        <th>Kelas</th>
                        <th>Pertanyaan</th>
                        <th>Tipe</th>
                        <th>Asal Ujian</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($data['questions'] as $q): ?>
                        <tr>
                            <td><?php echo $q->nama_mapel ?? '-'; ?></td>
                            <td><?php echo $q->nama_kelas ?? '-'; ?></td>
                            <td><?php echo substr(strip_tags($q->pertanyaan), 0, 50) . '...'; ?></td>
                            <td>
                                <!-- Type is typically Multiple Choice for now -->
                                <span class="badge bg-secondary">Pilihan Ganda</span>
                            </td>
                            <td><?php echo $q->exam_title; ?></td>
                            <td>
                                <a href="<?php echo BASE_URL; ?>guru/questions/<?php echo $q->ujian_id; ?>" class="btn btn-info btn-sm">
                                    <i class="fas fa-eye"></i> Lihat
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
