<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">Edit Ujian</div>
            <div class="card-body">
                <form action="<?php echo BASE_URL; ?>guru/update_exam" method="POST">
                    <input type="hidden" name="id" value="<?php echo $data['exam']->id; ?>">
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Judul Ujian</label>
                        <input type="text" class="form-control" name="title" value="<?php echo htmlspecialchars($data['exam']->title); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Deskripsi (Opsional)</label>
                        <textarea class="form-control" name="description" rows="3"><?php echo htmlspecialchars($data['exam']->description); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Mata Pelajaran</label>
                        <select name="subject_id" class="form-select" required>
                            <option value="">-- Pilih Mata Pelajaran --</option>
                            <?php foreach($data['subjects'] as $subject): ?>
                                <option value="<?php echo $subject->id; ?>" <?php echo ($data['exam']->subject_id == $subject->id) ? 'selected' : ''; ?>>
                                    <?php echo $subject->name; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                             <label for="duration_minutes" class="form-label">Durasi (Menit)</label>
                             <input type="number" class="form-control" name="duration_minutes" value="<?php echo $data['exam']->duration_minutes; ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                             <label for="token" class="form-label">Token Ujian</label>
                             <input type="text" class="form-control" name="token" value="<?php echo htmlspecialchars($data['exam']->token); ?>" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                             <label for="start_datetime" class="form-label">Tanggal/Waktu Mulai</label>
                             <input type="datetime-local" class="form-control" name="start_datetime" value="<?php echo date('Y-m-d\TH:i', strtotime($data['exam']->start_datetime)); ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                             <label for="end_datetime" class="form-label">Tanggal/Waktu Selesai</label>
                             <input type="datetime-local" class="form-control" name="end_datetime" value="<?php echo date('Y-m-d\TH:i', strtotime($data['exam']->end_datetime)); ?>" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kelas (Target Peserta)</label>
                        <select name="class_id" class="form-select" required>
                            <option value="">-- Pilih Kelas --</option>
                            <?php foreach($data['classes'] as $cls): ?>
                                <option value="<?php echo $cls->id; ?>" <?php echo ($data['exam']->class_id == $cls->id) ? 'selected' : ''; ?>>
                                    <?php echo $cls->name; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-warning text-white">Update Ujian</button>
                        <a href="<?php echo BASE_URL; ?>guru/exams" class="btn btn-secondary">Batal</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
