<div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Kelola Ujian</h2>
    <a href="<?php echo BASE_URL; ?>guru/create_exam" class="btn btn-primary"><i class="fas fa-plus"></i> Buat Ujian Baru</a>
</div>

<!-- Info & Legend Box -->
<div class="alert alert-light border shadow-sm mb-4" role="alert" style="border-left: 5px solid #0d6efd !important;">
    <div class="d-flex align-items-start">
        <div class="me-3 mt-1">
            <i class="fas fa-info-circle fa-2x text-primary"></i>
        </div>
        <div class="w-100">
            <h5 class="alert-heading fw-bold text-primary mb-2">Panduan Halaman Kelola Ujian</h5>
            <p class="mb-3 text-secondary" style="line-height: 1.5;">
                Halaman ini berfungsi sebagai pusat kontrol ujian. Di sini Anda dapat:
                <ul class="mb-2 small text-secondary">
                    <li>Membuat dan menjadwalkan ujian baru.</li>
                    <li>Mengelola soal-soal (Pilihan Ganda, Essay, dll) untuk setiap ujian.</li>
                    <li>Melihat hasil pengerjaan siswa dan melakukan koreksi manual jika diperlukan.</li>
                </ul>
            </p>
            
            <div class="bg-white p-3 rounded border">
                <h6 class="fw-bold small text-uppercase text-dark mb-3 border-bottom pb-2">Keterangan Tombol Aksi</h6>
                <div class="row g-3">
                    <div class="col-md-6 col-lg-3">
                        <div class="d-flex align-items-center p-2 border rounded hover-shadow-sm">
                            <button class="btn btn-sm btn-primary me-2 disabled" style="opacity:1; width:32px; height:32px; padding:0;"><i class="fas fa-clipboard-check"></i></button>
                            <div class="d-flex flex-column">
                                <span class="fw-bold small text-dark">Hasil & Koreksi</span>
                                <span style="font-size: 11px;" class="text-muted">Lihat nilai & koreksi manual</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="d-flex align-items-center p-2 border rounded hover-shadow-sm">
                            <button class="btn btn-sm btn-info text-white me-2 disabled" style="opacity:1; width:32px; height:32px; padding:0;"><i class="fas fa-question-circle"></i></button>
                            <div class="d-flex flex-column">
                                <span class="fw-bold small text-dark">Atur Soal</span>
                                <span style="font-size: 11px;" class="text-muted">Tambah/Edit pertanyaan exam</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="d-flex align-items-center p-2 border rounded hover-shadow-sm">
                            <button class="btn btn-sm btn-warning text-white me-2 disabled" style="opacity:1; width:32px; height:32px; padding:0;"><i class="fas fa-edit"></i></button>
                            <div class="d-flex flex-column">
                                <span class="fw-bold small text-dark">Edit Detail</span>
                                <span style="font-size: 11px;" class="text-muted">Ubah judul, waktu & durasi</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="d-flex align-items-center p-2 border rounded hover-shadow-sm">
                            <button class="btn btn-sm btn-danger me-2 disabled" style="opacity:1; width:32px; height:32px; padding:0;"><i class="fas fa-trash"></i></button>
                            <div class="d-flex flex-column">
                                <span class="fw-bold small text-dark">Hapus</span>
                                <span style="font-size: 11px;" class="text-muted">Hapus ujian ujian ini</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Judul</th>
                        <th>Durasi</th>
                        <th>Waktu Mulai/Selesai</th>
                        <th>Token</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($data['exams'])): ?>
                        <tr><td colspan="6" class="text-center">Tidak ada ujian ditemukan.</td></tr>
                    <?php else: ?>
                        <?php foreach($data['exams'] as $exam): ?>
                            <tr>
                                <td><?php echo $exam->title; ?></td>
                                <td><?php echo $exam->duration_minutes; ?> Menit</td>
                                <td>
                                    <small>
                                        Mulai: <?php echo $exam->start_datetime; ?><br>
                                        Selesai: <?php echo $exam->end_datetime; ?>
                                    </small>
                                </td>
                                <td><span class="badge bg-info text-dark"><?php echo $exam->token; ?></span></td>
                                <td>
                                    <?php if($exam->status == 'published'): ?>
                                        <span class="badge bg-success mb-1">Dipublikasi</span>
                                    <?php elseif($exam->status == 'closed'): ?>
                                        <span class="badge bg-danger mb-1">Ditutup</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary mb-1">Draf</span>
                                    <?php endif; ?>
                                    <div class="mt-1">
                                        <?php if($exam->status != 'published'): ?>
                                            <a href="<?php echo BASE_URL; ?>guru/set_status/<?php echo $exam->id; ?>/published" class="btn btn-sm btn-success py-0" style="font-size: 0.7rem;" title="Aktifkan"><i class="fas fa-check"></i> Aktif</a>
                                        <?php endif; ?>
                                        <?php if($exam->status != 'closed'): ?>
                                            <a href="<?php echo BASE_URL; ?>guru/set_status/<?php echo $exam->id; ?>/closed" class="btn btn-sm btn-dark py-0" style="font-size: 0.7rem;" title="Nonaktifkan"><i class="fas fa-times"></i> Nonaktif</a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>guru/results/<?php echo $exam->id; ?>" class="btn btn-sm btn-primary text-white" title="Hasil & Koreksi"><i class="fas fa-clipboard-check"></i></a>
                                    <a href="<?php echo BASE_URL; ?>guru/questions/<?php echo $exam->id; ?>" class="btn btn-sm btn-info text-white" title="Kelola Soal"><i class="fas fa-question-circle"></i></a>
                                    <a href="<?php echo BASE_URL; ?>guru/edit_exam/<?php echo $exam->id; ?>" class="btn btn-sm btn-warning text-white" title="Ubah Properti"><i class="fas fa-edit"></i></a>
                                    <a href="<?php echo BASE_URL; ?>guru/delete_exam/<?php echo $exam->id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Apakah Anda yakin?');" title="Hapus"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
