<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Laporan Hasil Ujian</title>
    <style>
        body { font-family: sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #333; padding: 8px; text-align: left; font-size: 12px; }
        th { background-color: #f2f2f2; font-weight: bold; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 3px solid #333; padding-bottom: 15px; }
        .header h2 { margin: 5px 0; font-size: 18px; }
        .header h3 { margin: 5px 0; font-size: 16px; color: #555; }
        .details { margin-bottom: 20px; line-height: 1.8; }
        .details strong { display: inline-block; width: 150px; }
        @media print {
            .no-print { display: none; }
            @page { margin: 1cm; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="no-print" style="margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #4e73df; color: white; border: none; border-radius: 5px; cursor: pointer;">
            <i class="fas fa-print"></i> Print / Save as PDF
        </button>
    </div>

    <div class="header">
        <h2>LAPORAN HASIL UJIAN</h2>
        <h3><?php echo strtoupper(APP_NAME); ?></h3>
        <p style="margin: 5px 0; font-size: 12px;">Jl. Contoh No. 123, Kota</p>
    </div>

    <div class="details">
        <strong>Ujian:</strong> <?php echo htmlspecialchars($data['exam']->title); ?><br>
        <strong>Mata Pelajaran:</strong> <?php echo htmlspecialchars($data['exam']->description); ?><br>
        <strong>Tanggal Cetak:</strong> <?php echo date('d-m-Y H:i:s'); ?>
    </div>

    <table>
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="30%">Nama Siswa</th>
                <th width="15%">Kelas</th>
                <th width="15%">Status</th>
                <th width="15%">Nilai</th>
            </tr>
        </thead>
        <tbody>
            <?php if(empty($data['results'])): ?>
                <tr><td colspan="5" style="text-align: center;">Belum ada data hasil ujian</td></tr>
            <?php else: ?>
                <?php $no = 1; foreach($data['results'] as $row): ?>
                <tr>
                    <td><?php echo $no++; ?></td>
                    <td><?php echo htmlspecialchars($row->student_name); ?></td>
                    <td><?php echo htmlspecialchars($row->class_name); ?></td>
                    <td><?php echo ucfirst($row->status); ?></td>
                    <td><strong><?php echo number_format($row->score ?? 0, 2); ?></strong></td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
