<div class="container-fluid px-4 mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800"><i class="fas fa-marker me-2"></i> Koreksi Jawaban</h1>
            <p class="mb-0 text-muted">Siswa: <strong><?php echo $data['student']->name; ?></strong> | Ujian: <?php echo $data['exam']->title; ?></p>
        </div>
        <a href="<?php echo BASE_URL; ?>guru/results/<?php echo $data['exam']->id; ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <form action="<?php echo BASE_URL; ?>guru/save_grades/<?php echo $data['session']->id; ?>" method="POST">
        <div class="card shadow mb-4">
            <div class="card-header py-3 bg-primary text-white">
                <h6 class="m-0 font-weight-bold">Lembar Jawaban Siswa</h6>
            </div>
            <div class="card-body">
                <?php foreach($data['questions'] as $index => $q): ?>
                    <?php 
                        $ans = isset($data['ans_map'][$q->id]) ? $data['ans_map'][$q->id] : null;
                        $score = $ans ? $ans->score : 0;
                        $answer_text = $ans ? $ans->selected_option : '<span class="text-danger">Tidak dijawab</span>';
                        
                        // Format Answer Text for Complex Types
                        if ($ans) {
                            $decoded = json_decode($answer_text, true);
                            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                                if (isset($decoded[0]) || empty($decoded)) { // Simple Array (Checkbox filters)
                                    // Map IDs to text (if we had options map, but we don't eager load options here efficiently)
                                    // Just show IDs or raw JSON for now, or improve later.
                                    // For Checkbox:
                                    $answer_text = "Opsi ID: " . implode(", ", $decoded);
                                } else {
                                    // Assoc Array (Matching)
                                    $list = [];
                                    foreach($decoded as $k => $v) $list[] = "$k => $v";
                                    $answer_text = implode("<br>", $list);
                                }
                            }
                        }
                        
                        $bg_class = ($q->type == 'essay') ? 'bg-warning-subtle' : ''; 
                    ?>
                    <div class="border rounded p-3 mb-3 <?php echo $bg_class; ?>">
                        <div class="d-flex justify-content-between">
                            <h5 class="font-weight-bold">No. <?php echo $index+1; ?> (<?php echo ucfirst($q->type); ?>)</h5>
                            <span class="badge bg-info">Max: 10 Poin</span>
                        </div>
                        <div class="mb-2">
                            <strong>Pertanyaan:</strong><br>
                            <?php echo nl2br($q->question_text); ?>
                        </div>
                        
                        <div class="mb-3 p-2 bg-light rounded">
                            <strong>Jawaban Siswa:</strong><br>
                            <div class="text-dark font-monospace"><?php echo $answer_text; ?></div>
                        </div>

                        <div class="form-group row align-items-center">
                            <label class="col-sm-2 col-form-label fw-bold">Berikan Nilai:</label>
                            <div class="col-sm-3">
                                <?php if($ans): ?>
                                    <input type="number" step="0.01" min="0" max="10" 
                                           class="form-control" 
                                           name="scores[<?php echo $ans->id; ?>]" 
                                           value="<?php echo $score; ?>">
                                <?php else: ?>
                                    <input type="text" class="form-control" value="0" disabled>
                                    <small class="text-muted">Tidak dijawab</small>
                                <?php endif; ?>
                            </div>
                            <div class="col-sm-7 text-muted small">
                                * Otomatis diisi oleh sistem (jika soal pilihan ganda), silakan ubah jika perlu.
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="card-footer text-end">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-save me-2"></i> Simpan Nilai & Rekap Ulang
                </button>
            </div>
        </div>
    </form>
</div>
