<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h5 class="m-0">Tambah Soal ke: <?php echo $data['exam']->title; ?></h5>
            </div>
            <div class="card-body">
                <form action="<?php echo BASE_URL; ?>guru/store_question" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="exam_id" value="<?php echo $data['exam']->id; ?>">
                    
                    <!-- Top Section: Type & Question Text -->
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold">Tipe Soal</label>
                            <select class="form-select" name="type" id="type_selector" onchange="toggleForm()">
                                <option value="pilihan_ganda">Pilihan Ganda (Standard)</option>
                                <option value="benar_salah">Benar / Salah (True/False)</option>
                                <option value="pilihan_ganda_kompleks">Pilihan Ganda Kompleks (Checkbox)</option>
                                <option value="menjodohkan">Menjodohkan (Matching)</option>
                                <option value="isian_singkat">Isian Singkat</option>
                                <option value="uraian">Uraian (Essay)</option>
                            </select>
                        </div>
                        <div class="col-md-8 mb-3">
                            <label class="form-label fw-bold">Gambar Soal (Opsional)</label>
                            <input type="file" class="form-control" name="question_image" accept="image/*">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Teks Pertanyaan</label>
                        <textarea class="form-control formula-input" name="question_text" rows="6" required placeholder="Tulis pertanyaan di sini... (Untuk rumus matematika, formatting akan dipertahankan)"></textarea>
                        <small class="text-muted"><i class="fas fa-info-circle"></i> Format rumus matematika akan dipertahankan dengan spacing dan line breaks</small>
                    </div>

                    <hr>

                    <!-- Section: Simple Multiple Choice (Legacy A-E) -->
                    <div id="section-simple">
                        <h6 class="text-primary mb-3"><i class="fas fa-list-ul"></i> Pilihan Jawaban (Standard)</h6>
                        <div class="row">
                            <?php $opts = ['a','b','c','d','e']; foreach($opts as $o): ?>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Pilihan <?php echo strtoupper($o); ?></label>
                                <input type="text" class="form-control simple-input mb-2" name="option_<?php echo $o; ?>" placeholder="Teks pilihan <?php echo strtoupper($o); ?>">
                                
                                <label class="form-label text-muted small"><i class="fas fa-image"></i> Gambar (Opsional)</label>
                                <input type="file" class="form-control form-control-sm simple-input" name="option_<?php echo $o; ?>_image" accept="image/*" onchange="previewOptionImage(this, '<?php echo $o; ?>')">
                                <div id="preview_<?php echo $o; ?>" class="mt-2"></div>
                            </div>
                            <?php endforeach; ?>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold text-success">Kunci Jawaban</label>
                                <select class="form-select simple-input" name="answer_key">
                                    <option value="A">A</option>
                                    <option value="B">B</option>
                                    <option value="C">C</option>
                                    <option value="D">D</option>
                                    <option value="E">E</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Section: Advanced (Dynamic Rows) -->
                    <div id="section-advanced" style="display:none;">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="text-primary m-0"><i class="fas fa-tasks"></i> Opsi Jawaban Dinamis</h6>
                            <button type="button" class="btn btn-sm btn-success" onclick="addOptionRow()"><i class="fas fa-plus"></i> Tambah Opsi</button>
                        </div>
                        
                        <div id="advanced-options-container">
                            <!-- JS will populate rows here -->
                        </div>
                        <small class="text-muted fst-italic">* Upload gambar per opsi jika diperlukan.</small>
                    </div>

                    <!-- Section: Short Answer Key -->
                    <div id="section-text" style="display:none;">
                         <div class="mb-3">
                            <label class="form-label fw-bold text-success">Kunci Jawaban (Untuk Auto-Correction)</label>
                            <input type="text" class="form-control" name="answer_key_text" placeholder="Contoh: Jakarta">
                            <small class="text-muted">Jawaban siswa harus persis sama (case-insensitive).</small>
                        </div>
                    </div>

                    <div class="d-grid gap-2 mt-4">
                        <button type="submit" class="btn btn-primary btn-lg">Simpan Soal</button>
                        <a href="<?php echo BASE_URL; ?>guru/questions/<?php echo $data['exam']->id; ?>" class="btn btn-secondary">Batal</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
/* Formula-friendly textarea styling */
.formula-input {
    white-space: pre-wrap;
    font-family: 'Courier New', Consolas, monospace;
    font-size: 14px;
    line-height: 1.8;
    letter-spacing: 0.3px;
}

/* Image preview styling */
.option-image-preview {
    max-width: 100%;
    max-height: 150px;
    border: 2px solid #dee2e6;
    border-radius: 6px;
    padding: 4px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.preview-container {
    position: relative;
    display: inline-block;
}

.remove-preview {
    position: absolute;
    top: -8px;
    right: -8px;
    background: #dc3545;
    color: white;
    border: none;
    border-radius: 50%;
    width: 24px;
    height: 24px;
    cursor: pointer;
    font-size: 14px;
    line-height: 1;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

.remove-preview:hover {
    background: #c82333;
}
</style>

<script>
let optionCount = 0;

// Preview image for standard options (A-E)
function previewOptionImage(input, optionLetter) {
    const previewDiv = document.getElementById('preview_' + optionLetter);
    previewDiv.innerHTML = ''; // Clear previous preview
    
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const container = document.createElement('div');
            container.className = 'preview-container';
            
            const img = document.createElement('img');
            img.src = e.target.result;
            img.className = 'option-image-preview';
            img.alt = 'Preview Opsi ' + optionLetter.toUpperCase();
            
            const removeBtn = document.createElement('button');
            removeBtn.type = 'button';
            removeBtn.className = 'remove-preview';
            removeBtn.innerHTML = '×';
            removeBtn.title = 'Hapus gambar';
            removeBtn.onclick = function() {
                input.value = '';
                previewDiv.innerHTML = '';
            };
            
            container.appendChild(img);
            container.appendChild(removeBtn);
            previewDiv.appendChild(container);
        };
        reader.readAsDataURL(input.files[0]);
    }
}

function toggleForm() {
    const type = document.getElementById('type_selector').value;
    const simpleSec = document.getElementById('section-simple');
    const advancedSec = document.getElementById('section-advanced');
    const textSec = document.getElementById('section-text');

    // Reset visibility
    simpleSec.style.display = 'none';
    advancedSec.style.display = 'none';
    textSec.style.display = 'none';

    // Disable built-in required fields to avoid validation blocking
    document.querySelectorAll('.simple-input').forEach(el => el.disabled = true);

    if (type === 'pilihan_ganda') {
        simpleSec.style.display = 'block';
        document.querySelectorAll('.simple-input').forEach(el => el.disabled = false);
    } 
    else if (type === 'benar_salah') {
        // Use advanced section for True/False
        advancedSec.style.display = 'block';
        // Pre-populate with Benar and Salah if empty
        if (optionCount === 0) {
            addTrueFalseOptions();
        }
    }
    else if (type === 'pilihan_ganda_kompleks' || type === 'menjodohkan') {
        advancedSec.style.display = 'block';
        if (optionCount === 0) addOptionRow(); // Add first row if empty
    } 
    else if (type === 'isian_singkat') {
        textSec.style.display = 'block';
    }
}

// Add True/False options automatically
function addTrueFalseOptions() {
    const container = document.getElementById('advanced-options-container');
    container.innerHTML = ''; // Clear first
    optionCount = 0;
    
    // Add "Benar" option
    const trueHtml = `
        <div class="card mb-2 p-2 bg-light border" id="opt-row-${optionCount}">
            <div class="row g-2 align-items-center">
                <div class="col-md-5">
                    <input type="text" class="form-control" name="adv_options[${optionCount}][text]" value="Benar" readonly required>
                </div>
                <div class="col-md-3">
                    <span class="text-muted small">Opsi True</span>
                </div>
                <div class="col-md-1 d-flex align-items-center justify-content-center">
                    <div class="form-check" title="Tandai sebagai Benar">
                        <input class="form-check-input bg-success border-success" type="checkbox" name="adv_options[${optionCount}][is_correct]" value="1" style="transform: scale(1.3);">
                    </div>
                </div>
            </div>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', trueHtml);
    optionCount++;
    
    // Add "Salah" option
    const falseHtml = `
        <div class="card mb-2 p-2 bg-light border" id="opt-row-${optionCount}">
            <div class="row g-2 align-items-center">
                <div class="col-md-5">
                    <input type="text" class="form-control" name="adv_options[${optionCount}][text]" value="Salah" readonly required>
                </div>
                <div class="col-md-3">
                    <span class="text-muted small">Opsi False</span>
                </div>
                <div class="col-md-1 d-flex align-items-center justify-content-center">
                    <div class="form-check" title="Tandai sebagai Benar">
                        <input class="form-check-input bg-success border-success" type="checkbox" name="adv_options[${optionCount}][is_correct]" value="1" style="transform: scale(1.3);">
                    </div>
                </div>
            </div>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', falseHtml);
    optionCount++;
}

function addOptionRow() {
    const container = document.getElementById('advanced-options-container');
    const type = document.getElementById('type_selector').value;
    const idx = optionCount++;
    
    let pairHtml = '';
    let correctHtml = '';

    if (type === 'menjodohkan') {
        pairHtml = `
            <div class="col-md-5">
                <input type="text" class="form-control" name="adv_options[${idx}][pair]" placeholder="Pasangan (Kanan)" required>
            </div>
        `;
    } else {
        // Checkbox for correct answer
        correctHtml = `
            <div class="col-md-1 d-flex align-items-center justify-content-center">
                <div class="form-check" title="Tandai sebagai Benar">
                    <input class="form-check-input bg-success border-success" type="checkbox" name="adv_options[${idx}][is_correct]" value="1" style="transform: scale(1.3);">
                </div>
            </div>
        `;
    }

    const html = `
        <div class="card mb-2 p-2 bg-light border" id="opt-row-${idx}">
            <div class="row g-2 align-items-center">
                <div class="col-md-5">
                    <input type="text" class="form-control" name="adv_options[${idx}][text]" placeholder="Teks Opsi" required>
                </div>
                ${pairHtml}
                <div class="col-md-3">
                    <input type="file" class="form-control form-control-sm" name="adv_opt_img_${idx}">
                </div>
                ${correctHtml}
                <div class="col-md-1 text-end">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeOptionRow(${idx})"><i class="fas fa-trash"></i></button>
                </div>
            </div>
        </div>
    `;
    
    container.insertAdjacentHTML('beforeend', html);
}

function removeOptionRow(idx) {
    const row = document.getElementById(`opt-row-${idx}`);
    if(row) row.remove();
}

// Init
document.addEventListener('DOMContentLoaded', toggleForm);
</script>
