<div class="d-flex justify-content-between align-items-center mb-3">
    <div>
        <h2>Soal untuk: <?php echo $data['exam']->title; ?></h2>
        <a href="<?php echo BASE_URL; ?>guru/exams" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Kembali ke Ujian</a>
    </div>
    <div>
        <a href="<?php echo BASE_URL; ?>guru/results/<?php echo $data['exam']->id; ?>" class="btn btn-warning text-white me-2"><i class="fas fa-poll"></i> Hasil & Nilai</a>
        <a href="<?php echo BASE_URL; ?>guru/add_question/<?php echo $data['exam']->id; ?>" class="btn btn-primary"><i class="fas fa-plus"></i> Tambah Soal</a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <?php if(empty($data['questions'])): ?>
            <p class="text-center text-muted my-5">Belum ada soal ditambahkan.</p>
        <?php else: ?>
            <div class="accordion" id="questionsAccordion">
                <?php foreach($data['questions'] as $index => $q): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading<?php echo $q->id; ?>">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $q->id; ?>">
                                Q<?php echo $index + 1; ?>: <?php echo substr(strip_tags($q->question_text), 0, 50); ?>... (Kunci: <?php echo $q->answer_key; ?>)
                            </button>
                        </h2>
                        <div id="collapse<?php echo $q->id; ?>" class="accordion-collapse collapse" data-bs-parent="#questionsAccordion">
                            <div class="accordion-body">
                                <p><strong>Soal:</strong><br><?php echo nl2br($q->question_text); ?></p>
                                <ul class="list-group">
                                    <li class="list-group-item <?php echo ($q->answer_key == 'A') ? 'list-group-item-success' : ''; ?>">A. <?php echo $q->option_a; ?></li>
                                    <li class="list-group-item <?php echo ($q->answer_key == 'B') ? 'list-group-item-success' : ''; ?>">B. <?php echo $q->option_b; ?></li>
                                    <li class="list-group-item <?php echo ($q->answer_key == 'C') ? 'list-group-item-success' : ''; ?>">C. <?php echo $q->option_c; ?></li>
                                    <li class="list-group-item <?php echo ($q->answer_key == 'D') ? 'list-group-item-success' : ''; ?>">D. <?php echo $q->option_d; ?></li>
                                    <li class="list-group-item <?php echo ($q->answer_key == 'E') ? 'list-group-item-success' : ''; ?>">E. <?php echo $q->option_e; ?></li>
                                </ul>
                                <div class="mt-3 text-end">
                                    <a href="<?php echo BASE_URL; ?>guru/delete_question/<?php echo $q->id; ?>/<?php echo $data['exam']->id; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Hapus soal ini?');">Hapus</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
