<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Hasil Ujian: <?php echo $data['exam']->title; ?></h1>
    <div>
        <!-- Publish Toggle -->
        <?php if($data['exam']->show_results): ?>
            <a href="<?php echo BASE_URL; ?>guru/publish_results/<?php echo $data['exam']->id; ?>" class="btn btn-sm btn-warning shadow-sm me-2">
                <i class="fas fa-eye-slash fa-sm text-white-50"></i> Sembunyikan Nilai
            </a>
        <?php else: ?>
            <a href="<?php echo BASE_URL; ?>guru/publish_results/<?php echo $data['exam']->id; ?>" class="btn btn-sm btn-info shadow-sm me-2">
                <i class="fas fa-eye fa-sm text-white-50"></i> Terbitkan Nilai
            </a>
        <?php endif; ?>

        <a href="<?php echo BASE_URL; ?>guru/export_scores/<?php echo $data['exam']->id; ?>/excel" class="btn btn-sm btn-success shadow-sm"><i class="fas fa-file-excel fa-sm text-white-50"></i> Export Excel</a>
        <a href="<?php echo BASE_URL; ?>guru/export_scores/<?php echo $data['exam']->id; ?>/pdf" class="btn btn-sm btn-danger shadow-sm"><i class="fas fa-file-pdf fa-sm text-white-50"></i> Export PDF</a>
    </div>
</div>

<?php if($data['exam']->show_results): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle me-2"></i> Nilai <strong>Sudah Diterbitkan</strong>. Siswa dapat melihat nilai mereka.
    </div>
<?php else: ?>
    <div class="alert alert-warning">
        <i class="fas fa-exclamation-triangle me-2"></i> Nilai <strong>Belum Diterbitkan</strong>. Harap koreksi jawaban essay (jika ada) sebelum menerbitkan nilai.
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Daftar Nilai Siswa</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Siswa</th>
                        <th>Kelas</th>
                        <th>Status</th>
                        <th>Nilai</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($data['results'])): ?>
                        <tr><td colspan="6" class="text-center">Belum ada siswa yang mengerjakan.</td></tr>
                    <?php else: ?>
                        <?php $no = 1; foreach($data['results'] as $row): ?>
                            <tr>
                                <td><?php echo $no++; ?></td>
                                <td><?php echo $row->student_name; ?></td>
                                <td><?php echo $row->class_name; ?></td>
                                <td>
                                    <?php 
                                        $badges = ['ongoing'=>'primary', 'completed'=>'success', 'banned'=>'danger'];
                                        $bg = isset($badges[$row->status]) ? $badges[$row->status] : 'secondary';
                                    ?>
                                    <span class="badge bg-<?php echo $bg; ?>"><?php echo ucfirst($row->status); ?></span>
                                </td>
                                <td><strong><?php echo number_format($row->score ?? 0, 2); ?></strong></td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>guru/grade_student/<?php echo $row->id; ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-marker"></i> Koreksi
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

