<?php
// Fetch school settings for header
require_once '../app/core/Database.php';
require_once '../app/models/SchoolSettings.php';
$schoolSettingsModel = new SchoolSettings();
$schoolSettings = $schoolSettingsModel->getAllSettings();
$schoolName = $schoolSettings['school_name'] ?? APP_NAME;
$schoolLogo = $schoolSettings['school_logo'] ?? null;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($data['title']) ? $data['title'] : $schoolName; ?></title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>assets/css/style.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <!-- Modern Top Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
        <div class="container-fluid">
            <!-- Sidebar Toggle (Mobile) -->
            <button class="sidebar-toggle me-2 d-md-none" id="sidebarToggle" aria-label="Toggle Sidebar">
                <i class="fas fa-bars"></i>
            </button>

            <!-- Brand with Logo -->
            <a class="navbar-brand d-flex align-items-center" href="<?php echo BASE_URL . $_SESSION['role']; ?>/dashboard" style="font-weight: 600; font-size: 1.1rem;">
                <?php if ($schoolLogo): ?>
                    <img src="<?php echo BASE_URL; ?>uploads/school/<?php echo $schoolLogo; ?>" 
                         alt="Logo" 
                         style="height: 35px; width: 35px; object-fit: contain; margin-right: 10px; background: white; border-radius: 8px; padding: 3px;">
                <?php else: ?>
                    <i class="fas fa-graduation-cap me-2" style="font-size: 1.5rem;"></i>
                <?php endif; ?>
                <span><?php echo $schoolName; ?></span>
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <!-- User Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" role="button" data-bs-toggle="dropdown" style="padding: 8px 15px;">
                            <div class="d-flex align-items-center">
                                <div class="me-2" style="background: rgba(255,255,255,0.2); border-radius: 50%; width: 32px; height: 32px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-user" style="font-size: 0.9rem;"></i>
                                </div>
                                <div class="d-none d-lg-block text-start">
                                    <div style="font-size: 0.9rem; font-weight: 500;"><?php echo $_SESSION['name']; ?></div>
                                    <div style="font-size: 0.75rem; opacity: 0.9;"><?php echo ucfirst($_SESSION['role']); ?></div>
                                </div>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" style="border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.15);">
                            <li><a class="dropdown-item" href="<?php echo BASE_URL . $_SESSION['role']; ?>/profile"><i class="fas fa-user-circle me-2"></i> Profil Saya</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="<?php echo BASE_URL; ?>auth/logout"><i class="fas fa-sign-out-alt me-2"></i> Keluar</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Sidebar Backdrop (for mobile) -->
    <div class="sidebar-backdrop" id="sidebarBackdrop"></div>

    <!-- Main Container -->
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar p-0" id="sidebar">
                <!-- Close button for mobile -->
                <button class="sidebar-close" id="sidebarClose" aria-label="Close Sidebar">
                    <i class="fas fa-times"></i>
                </button>

                <div class="d-flex flex-column pt-3">
                    <?php if ($_SESSION['role'] == 'admin'): ?>
                        <a href="<?php echo BASE_URL; ?>admin/dashboard" class="<?php echo ($data['active_menu'] == 'dashboard') ? 'active' : ''; ?>"><i class="fas fa-tachometer-alt me-2"></i> Dashboard</a>
                        <a href="<?php echo BASE_URL; ?>admin/server" class="<?php echo ($data['active_menu'] == 'server') ? 'active' : ''; ?>"><i class="fas fa-server me-2"></i> Server & Traffic</a>
                        <a href="<?php echo BASE_URL; ?>class" class="<?php echo ($data['active_menu'] == 'classes') ? 'active' : ''; ?>"><i class="fas fa-chalkboard me-2"></i> Kelola Kelas</a>
                        <a href="<?php echo BASE_URL; ?>subject" class="<?php echo ($data['active_menu'] == 'subjects') ? 'active' : ''; ?>"><i class="fas fa-book me-2"></i> Kelola Mapel</a>
                        <a href="<?php echo BASE_URL; ?>admin/users" class="<?php echo ($data['active_menu'] == 'users') ? 'active' : ''; ?>"><i class="fas fa-users me-2"></i> Kelola Siswa/Pengguna</a>
                        <a href="<?php echo BASE_URL; ?>admin/print_cards" class="<?php echo ($data['active_menu'] == 'print_cards') ? 'active' : ''; ?>"><i class="fas fa-id-card me-2"></i> Cetak Kartu Ujian</a>
                        <a href="<?php echo BASE_URL; ?>admin/activity_logs" class="<?php echo ($data['active_menu'] == 'logs') ? 'active' : ''; ?>"><i class="fas fa-history me-2"></i> Log Aktivitas</a>
                        <!-- Moved Server up -->
                        <a href="<?php echo BASE_URL; ?>admin/school_settings" class="<?php echo ($data['active_menu'] == 'school_settings') ? 'active' : ''; ?>"><i class="fas fa-cog me-2"></i> Pengaturan Sekolah</a>
                        <a href="<?php echo BASE_URL; ?>admin/profile" class="<?php echo ($data['active_menu'] == 'profile') ? 'active' : ''; ?>"><i class="fas fa-user-circle me-2"></i> Profil Saya</a>
                    <?php elseif ($_SESSION['role'] == 'guru'): ?>
                        <a href="<?php echo BASE_URL; ?>guru/dashboard" class="<?php echo ($data['active_menu'] == 'dashboard') ? 'active' : ''; ?>"><i class="fas fa-tachometer-alt me-2"></i> Dashboard</a>
                        <a href="<?php echo BASE_URL; ?>guru/exams" class="<?php echo ($data['active_menu'] == 'exams') ? 'active' : ''; ?>"><i class="fas fa-file-alt me-2"></i> Ujian</a>
                        <a href="<?php echo BASE_URL; ?>guru/bank" class="<?php echo ($data['active_menu'] == 'bank') ? 'active' : ''; ?>"><i class="fas fa-database me-2"></i> Bank Soal</a>
                        <a href="<?php echo BASE_URL; ?>guru/profile" class="<?php echo ($data['active_menu'] == 'profile') ? 'active' : ''; ?>"><i class="fas fa-user-circle me-2"></i> Profil Saya</a>
                    <?php elseif ($_SESSION['role'] == 'siswa'): ?>
                        <a href="<?php echo BASE_URL; ?>siswa/dashboard" class="<?php echo ($data['active_menu'] == 'dashboard') ? 'active' : ''; ?>"><i class="fas fa-tachometer-alt me-2"></i> Dashboard</a>
                        <a href="<?php echo BASE_URL; ?>siswa/profile" class="<?php echo ($data['active_menu'] == 'profile') ? 'active' : ''; ?>"><i class="fas fa-user-circle me-2"></i> Profil Saya</a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Main Content Area -->
            <div class="col-md-9 col-lg-10 content bg-light p-4">
                <?php get_flash(); ?>
