<div class="row">
    <div class="col-md-12 mb-4">
        <h2 class="text-gray-800">Monitor Siswa</h2>
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Status Akun</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                             <span class="badge bg-success">Active</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-id-card fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 bg-primary text-white">
                <h6 class="m-0 font-weight-bold">Daftar Ujian Tersedia</h6>
            </div>
            <div class="card-body">
                <?php if(empty($data['exams'])): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-mug-hot fa-3x text-gray-300 mb-3"></i>
                        <p class="text-muted">Tidak ada ujian yang tersedia saat ini. Santai dulu!</p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                            <thead class="thead-light">
                                <tr>
                                    <th>Judul Ujian</th>
                                    <th>Guru</th>
                                    <th>Durasi</th>
                                    <th>Waktu Mulai</th>
                                    <th>Status Anda</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($data['exams'] as $exam): ?>
                                    <tr>
                                        <td><strong><?php echo $exam->title; ?></strong></td>
                                        <td><?php echo $exam->guru_name; ?></td>
                                        <td><?php echo $exam->duration_minutes; ?> Menit</td>
                                        <td><?php echo date('d M Y H:i', strtotime($exam->start_datetime)); ?></td>
                                        <td>
                                            <?php if($exam->session): ?>
                                                <?php if($exam->session->status == 'ongoing'): ?>
                                                    <span class="badge bg-warning text-dark">Sedang Mengerjakan</span>
                                                <?php elseif($exam->session->status == 'completed'): ?>
                                                    <span class="badge bg-success">Selesai (Nilai: <?php echo $exam->session->score; ?>)</span>
                                                <?php elseif($exam->session->status == 'banned'): ?>
                                                    <span class="badge bg-danger">BANNED</span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Belum Mulai</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($exam->session): ?>
                                                <?php if($exam->session->status == 'ongoing'): ?>
                                                    <a href="<?php echo BASE_URL; ?>siswa/join_exam/<?php echo $exam->id; ?>" class="btn btn-warning btn-sm"><i class="fas fa-play"></i> Lanjut</a>
                                                <?php elseif($exam->session->status == 'completed'): ?>
                                                    <button class="btn btn-secondary btn-sm" disabled><i class="fas fa-check"></i> Selesai</button>
                                                <?php elseif($exam->session->status == 'banned'): ?>
                                                    <button class="btn btn-danger btn-sm" disabled><i class="fas fa-ban"></i> Terkunci</button>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <a href="<?php echo BASE_URL; ?>siswa/join_exam/<?php echo $exam->id; ?>" class="btn btn-primary btn-sm"><i class="fas fa-rocket"></i> Mulai Kerjakan</a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
