<div class="row justify-content-center mt-5">
    <div class="col-md-6">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="fas fa-key me-2"></i> Masukkan Token Ujian</h4>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <h5 class="fw-bold mb-1"><?php echo $data['exam']->title; ?></h5>
                    <p class="text-muted small mb-3"><?php echo $data['exam']->description; ?></p>
                    
                    <div class="d-flex justify-content-center gap-3 mb-3">
                        <span class="badge bg-light text-dark border p-2"><i class="fas fa-clock me-1"></i> Durasi: <?php echo $data['exam']->duration_minutes; ?> Menit</span>
                        <span class="badge bg-light text-dark border p-2"><i class="fas fa-calendar-alt me-1"></i> Max: <?php echo date('d M H:i', strtotime($data['exam']->end_datetime)); ?></span>
                    </div>

                    <!-- Warning Alert -->
                    <div class="alert alert-warning text-start small border-warning shadow-sm" role="alert" style="background-color: #fff3cd;">
                        <h6 class="alert-heading fw-bold text-danger"><i class="fas fa-exclamation-triangle me-1"></i> PERINGATAN PENTING!</h6>
                        <ul class="mb-0 ps-3">
                            <li class="mb-1">Dilarang membuka tab baru atau aplikasi lain selama ujian.</li>
                            <li class="mb-1">Sistem akan otomatis mendeteksi kecurangan (ganti window/minimise).</li>
                            <li>Pastikan koneksi internet stabil sebelum memulai.</li>
                        </ul>
                    </div>

                    <div class="alert alert-info text-start small border-info shadow-sm" role="alert">
                        <h6 class="alert-heading fw-bold text-info"><i class="fas fa-info-circle me-1"></i> CARA MULAI</h6>
                        <p class="mb-0">Silakan minta <strong>TOKEN UJIAN</strong> kepada Pengawas Ujian di ruang Anda. Masukkan 6 digit kode token di bawah ini dengan benar.</p>
                    </div>
                </div>

                <form action="<?php echo BASE_URL; ?>siswa/join_exam/<?php echo $data['exam']->id; ?>" method="POST">
                    <div class="mb-3">
                        <label for="token" class="form-label">Token Ujian</label>
                        <input type="text" class="form-control form-control-lg text-center font-monospace text-uppercase" name="token" required placeholder="Masukkan Token" autocomplete="off">
                    </div>

                    <?php get_flash(); ?>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success btn-lg">Mulai Kerjakan</button>
                        <a href="<?php echo BASE_URL; ?>siswa/dashboard" class="btn btn-secondary">Batal</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
