<?php
// take_exam.php - Views for Taking Exam
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $data['title']; ?></title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        const BASE_URL = "<?php echo BASE_URL; ?>";
    </script>
    <style>
        body { background-color: #f8f9fc; user-select: none; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; }
        .question-card { border-left: 5px solid #4e73df; margin-bottom: 20px; }
        .blink { animation: blinker 1s linear infinite; }
        @keyframes blinker { 50% { opacity: 0; } }
        #timer-sticky { position: sticky; top: 0; z-index: 1000; background: white; padding: 10px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        
        /* Anti-Print / Anti-PDF Save */
        @media print {
            body { display: none !important; }
            html { display: none !important; }
            * { display: none !important; }
        }
    </style>
</head>
<body oncontextmenu="return false;"> <!-- Disable Right Click -->

<div class="Container-fluid px-4 mt-4">
    <input type="hidden" id="session_id" value="<?php echo $data['session']->id; ?>">
    <input type="hidden" id="remaining_seconds" value="<?php echo $data['remainingSeconds']; ?>">

    <?php if(!empty($data['isBanned'])): ?>
        <div class="alert alert-warning alert-dismissible fade show shadow-sm mb-3" role="alert">
            <h5 class="alert-heading"><i class="fas fa-exclamation-triangle me-2"></i> Peringatan Pelanggaran</h5>
            <p class="mb-0">Sistem mendeteksi aktivitas mencurigakan (pindah tab/aplikasi). Anda masih bisa melanjutkan ujian, tetapi pelanggaran sudah tercatat dan akan dievaluasi oleh Guru.</p>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if(empty($data['questions'])): ?>
        <div class="alert alert-danger shadow">
            <h4><i class="fas fa-exclamation-triangle"></i> Soal Belum Tersedia</h4>
            <p>Maaf, belum ada soal yang dibuat untuk ujian ini. Silakan hubungi Guru Anda.</p>
            <a href="<?php echo BASE_URL; ?>siswa/dashboard" class="btn btn-secondary mt-2">Kembali ke Dashboard</a>
        </div>
    <?php else: ?>
        <div class="row">
        <!-- Main Question Area -->
        <div class="col-lg-9 col-md-8">
            <!-- Header: Soal Ke & Timer -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <h4 class="m-0 font-weight-bold text-dark me-3">SOAL KE <span class="badge bg-danger ms-2" style="font-size: 1.2rem;" id="current-question-num">1</span></h4>
                </div>
                <div class="btn-group shadow-sm">
                    <button type="button" class="btn btn-warning fw-bold text-white">SISA WAKTU</button>
                    <button type="button" class="btn btn-primary fw-bold" id="timer-display">Loading...</button>
                </div>
            </div>

            <form id="exam-form">
                <?php foreach($data['questions'] as $index => $q): ?>
                    <!-- Question Card (Hidden by default, JS will show active) -->
                    <div class="card shadow mb-4 question-card" id="question-card-<?php echo $index; ?>" style="<?php echo $index === 0 ? '' : 'display:none;'; ?>">
                        <div class="card-body p-4">
                            <!-- Question Text & Image -->
                            <div class="mb-4">
                                <span class="badge bg-warning text-dark mb-2">Pertanyaan ke-<?php echo $index + 1; ?></span>
                                
                                <?php if(!empty($q->question_image)): ?>
                                    <div class="mb-3 text-center">
                                        <img src="<?php echo BASE_URL . 'uploads/questions/' . $q->question_image; ?>" class="img-fluid rounded shadow-sm" style="max-height: 300px;">
                                    </div>
                                <?php endif; ?>

                                <div class="lead fw-normal text-dark" style="font-size: 1.1rem; line-height: 1.6;">
                                    <?php echo nl2br($q->question_text); ?>
                                </div>
                            </div>
                            
                            <!-- Answer Input -->
                            <div class="mt-4">
                                <?php 
                                    $type = isset($q->type) ? $q->type : (isset($q->jenis) ? $q->jenis : 'pilihan_ganda');
                                ?>
                                
                                <?php if($type == 'pilihan_ganda' || $type == 'benar_salah'): ?>
                                    <div class="list-group">
                                        <?php 
                                            if(isset($q->options)): 
                                                foreach($q->options as $opt):
                                                    $val = ($type == 'benar_salah') ? $opt->id : $opt->id;
                                                    $label = $opt->teks_pilihan;
                                                    $checked = (isset($data['answers_map'][$q->id]) && $data['answers_map'][$q->id] == $val) ? 'checked' : '';
                                        ?>
                                            <label class="list-group-item list-group-item-action p-3 border rounded mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input me-2" type="radio" name="q_<?php echo $q->id; ?>" 
                                                           value="<?php echo $val; ?>" <?php echo $checked; ?> 
                                                           data-question-index="<?php echo $index; ?>" onchange="updateNavStatus(<?php echo $index; ?>)">
                                                    <span class="form-check-label"><?php echo $label; ?></span>
                                                    <?php if(!empty($opt->image)): ?>
                                                        <br><img src="<?php echo BASE_URL . 'uploads/questions/' . $opt->image; ?>" class="img-thumbnail mt-2" style="max-height: 150px;">
                                                    <?php endif; ?>
                                                </div>
                                            </label>
                                        <?php 
                                                endforeach;
                                            endif; 
                                        ?>
                                    </div>
                                
                                <?php elseif($type == 'pilihan_ganda_kompleks'): ?>
                                    <!-- Checkbox Group -->
                                    <div class="list-group">
                                        <?php 
                                            // Handle stored JSON answer
                                            $currentAns = isset($data['answers_map'][$q->id]) ? json_decode($data['answers_map'][$q->id], true) : [];
                                            if(!is_array($currentAns)) $currentAns = [];

                                            if(isset($q->options)): 
                                                foreach($q->options as $opt):
                                                    $val = $opt->id;
                                                    $checked = in_array($val, $currentAns) ? 'checked' : '';
                                        ?>
                                            <label class="list-group-item list-group-item-action p-3 border rounded mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input me-2" type="checkbox" name="q_<?php echo $q->id; ?>[]" 
                                                           value="<?php echo $val; ?>" <?php echo $checked; ?> 
                                                           data-question-index="<?php echo $index; ?>" onchange="updateNavStatus(<?php echo $index; ?>)">
                                                    <span class="form-check-label"><?php echo $opt->teks_pilihan; ?></span>
                                                    <?php if(!empty($opt->image)): ?>
                                                        <br><img src="<?php echo BASE_URL . 'uploads/questions/' . $opt->image; ?>" class="img-thumbnail mt-2" style="max-height: 150px;">
                                                    <?php endif; ?>
                                                </div>
                                            </label>
                                        <?php endforeach; endif; ?>
                                    </div>

                                <?php elseif($type == 'menjodohkan'): ?>
                                    <!-- Matching: Left (Text) - Right (Select) -->
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead class="bg-light">
                                                <tr>
                                                    <th>Pernyataan</th>
                                                    <th>Pasangan Jawaban</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                    // Prepare Right-side options (Shuffled)
                                                    $pairs = [];
                                                    if(isset($q->options)) {
                                                        foreach($q->options as $opt) { 
                                                            if(!empty($opt->pair_text)) $pairs[] = $opt->pair_text; 
                                                        }
                                                    }
                                                    sort($pairs); // Alphabetical sort for dropdown consistency, or shuffle? User usually wants random but consistent list.
                                                
                                                    $currentAns = isset($data['answers_map'][$q->id]) ? json_decode($data['answers_map'][$q->id], true) : [];
                                                    if(!is_array($currentAns)) $currentAns = [];

                                                    if(isset($q->options)): 
                                                        foreach($q->options as $opt):
                                                            $myVal = isset($currentAns[$opt->id]) ? $currentAns[$opt->id] : '';
                                                ?>
                                                <tr>
                                                    <td width="50%">
                                                        <?php echo $opt->teks_pilihan; ?>
                                                        <?php if(!empty($opt->image)): ?>
                                                            <br><img src="<?php echo BASE_URL . 'uploads/questions/' . $opt->image; ?>" class="img-thumbnail mt-2" style="max-height: 100px;">
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <select class="form-select" name="q_<?php echo $q->id; ?>[<?php echo $opt->id; ?>]" 
                                                                data-question-index="<?php echo $index; ?>" onchange="updateNavStatus(<?php echo $index; ?>)">
                                                            <option value="">-- Pilih Pasangan --</option>
                                                            <?php foreach($pairs as $p): ?>
                                                                <option value="<?php echo htmlspecialchars($p); ?>" <?php echo ($myVal == $p) ? 'selected' : ''; ?>>
                                                                    <?php echo $p; ?>
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                </tr>
                                                <?php endforeach; endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                <?php elseif($type == 'isian' || $type == 'isian_singkat'): ?>
                                    <div class="form-group">
                                        <input type="text" class="form-control form-control-lg" name="q_<?php echo $q->id; ?>" 
                                               placeholder="Ketik jawaban singkat Anda..." 
                                               value="<?php echo isset($data['answers_map'][$q->id]) ? $data['answers_map'][$q->id] : ''; ?>"
                                               data-question-index="<?php echo $index; ?>" oninput="updateNavStatus(<?php echo $index; ?>)">
                                    </div>

                                <?php elseif($type == 'essay' || $type == 'uraian'): ?>
                                    <textarea class="form-control" name="q_<?php echo $q->id; ?>" rows="5" 
                                              placeholder="Tulis jawaban uraian Anda di sini..." 
                                              data-question-index="<?php echo $index; ?>" oninput="updateNavStatus(<?php echo $index; ?>)"><?php echo isset($data['answers_map'][$q->id]) ? $data['answers_map'][$q->id] : ''; ?></textarea>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Card Footer Navigation -->
                        <div class="card-footer bg-white p-3 d-flex justify-content-center gap-2">
                            <button type="button" class="btn btn-success px-4" onclick="prevQuestion()" <?php echo $index === 0 ? 'disabled' : ''; ?>>
                                <i class="fas fa-chevron-left"></i> BACK
                            </button>
                            
                            <button type="button" class="btn btn-warning text-white px-4 fw-bold" onclick="toggleRagu(<?php echo $index; ?>)">
                                <input type="checkbox" class="form-check-input d-none" id="ragu_check_<?php echo $index; ?>">
                                <i class="fas fa-flag"></i> RAGU-RAGU
                            </button>

                            <?php if ($index < count($data['questions']) - 1): ?>
                                <button type="button" class="btn btn-success px-4" onclick="nextQuestion()">
                                    NEXT <i class="fas fa-chevron-right"></i>
                                </button>
                            <?php else: ?>
                                <button type="button" class="btn btn-primary px-4" onclick="window.isFinishing = true;" data-bs-toggle="modal" data-bs-target="#confirmFinishModal">
                                    SELESAI <i class="fas fa-check"></i>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </form>
        </div>

        <!-- Navigation Sidebar -->
        <div class="col-lg-3 col-md-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3 bg-primary text-white">
                    <h6 class="m-0 font-weight-bold"><i class="fas fa-th-large me-2"></i> NAVIGASI SOAL</h6>
                </div>
                <div class="card-body">
                    <div class="row g-2" id="nav-grid">
                        <?php foreach($data['questions'] as $index => $q): ?>
                            <?php 
                                // Determine initial color based on answer presence
                                $hasAnswer = isset($data['answers_map'][$q->id]);
                                $btnClass = $hasAnswer ? 'btn-success text-white' : 'btn-danger text-white';
                                if ($index === 0) $btnClass = 'btn-primary text-white'; // Active
                            ?>
                            <div class="col-3 col-sm-3 mb-2">
                                <button type="button" class="btn <?php echo $btnClass; ?> w-100" 
                                        id="nav-btn-<?php echo $index; ?>" 
                                        onclick="jumpToQuestion(<?php echo $index; ?>)">
                                    <?php echo $index + 1; ?>
                                </button>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer bg-light small">
                    <div class="d-flex align-items-center mb-1"><span class="badge bg-primary me-2">&nbsp;</span> Sedang Aktif</div>
                    <div class="d-flex align-items-center mb-1"><span class="badge bg-success me-2">&nbsp;</span> Sudah Dijawab</div>
                    <div class="d-flex align-items-center mb-1"><span class="badge bg-warning text-dark me-2">&nbsp;</span> Ragu-ragu</div>
                    <div class="d-flex align-items-center"><span class="badge bg-danger me-2">&nbsp;</span> Belum Dijawab</div>
                </div>
            </div>
            
            <div class="text-center d-none d-md-block">
                 <button type="button" class="btn btn-danger w-100 py-3" onclick="window.isFinishing = true;" data-bs-toggle="modal" data-bs-target="#confirmFinishModal">
                    <i class="fas fa-stop-circle me-2"></i> HENTIKAN UJIAN
                 </button>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Footer -->
<footer class="footer mt-5 py-3 bg-white shadow-sm border-top" style="background-color: rgba(255, 255, 255, 0.85) !important; backdrop-filter: blur(5px);">
    <div class="container-fluid">
        <div class="row align-items-center justify-content-between">
            <div class="col-md-6 text-center text-md-start mb-2 mb-md-0">
                <div class="small fw-bold text-muted">
                    <span>Dibuat oleh <a href="#" class="text-primary text-decoration-none">MH Studios</a> &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
            <div class="col-md-6 text-center text-md-end">
                <div class="d-inline-flex align-items-center gap-3">
                    <span class="small text-muted me-2">Ikuti Kami:</span>
                    <a href="https://www.youtube.com/@mhstudios4500" target="_blank" class="text-danger text-decoration-none" title="YouTube"><i class="fab fa-youtube fa-lg"></i></a>
                    <a href="https://www.instagram.com/maulanamalik_h12?igsh=MXh6OGo5a2Zwejkz" target="_blank" class="text-danger text-decoration-none" title="Instagram"><i class="fab fa-instagram fa-lg"></i></a>
                    <a href="https://wa.me/6285266789295" target="_blank" class="text-success text-decoration-none" title="WhatsApp"><i class="fab fa-whatsapp fa-lg"></i></a>
                </div>
            </div>
        </div>
    </div>
</footer>

<!-- Confirmation Modal -->
<div class="modal fade" id="confirmFinishModal" tabindex="-1" aria-labelledby="confirmFinishModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="confirmFinishModalLabel">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    Konfirmasi Selesai Ujian
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Perhatian!</strong> Setelah Anda menyelesaikan ujian, Anda tidak dapat mengubah jawaban lagi.
                </div>
                
                <p class="mb-3">Pastikan Anda sudah memeriksa semua jawaban sebelum menyelesaikan ujian.</p>
                
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="agreeFinish">
                    <label class="form-check-label fw-bold" for="agreeFinish">
                        Saya yakin ingin menyelesaikan ujian sekarang
                    </label>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Batal
                </button>
                <button type="button" class="btn btn-primary" id="confirmFinishBtn" onclick="confirmFinish()">
                    <i class="fas fa-check me-1"></i> Ya, Selesai
                </button>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo BASE_URL; ?>assets/js/exam.js?v=<?php echo time(); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
