-- Migration: Create school_settings table
-- Purpose: Store school configuration like name and logo

CREATE TABLE IF NOT EXISTS school_settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default values
INSERT INTO school_settings (setting_key, setting_value) VALUES
('school_name', 'Sistem Ujian Online'),
('school_logo', NULL),
('maintenance_mode', '0'),
('server_message', 'Maaf, server sedang dalam pemeliharaan. Silakan coba beberapa saat lagi.'),
('max_concurrent_users', '1000')
ON DUPLICATE KEY UPDATE setting_key = setting_key;
