<?php
// migrate.php
require_once 'app/config/config.php';
require_once 'app/core/Database.php';

echo "Running Migration...\n";

$db = new Database();
$sql = file_get_contents('update_schema_v2_questions.sql');

// Split by semicolon to execute one by one if needed, or just execute raw if PDO allows multiple statements
// PDO usually allows multiple statements if configured, but safe to split.
$statements = array_filter(array_map('trim', explode(';', $sql)));

foreach ($statements as $stmt) {
    if (!empty($stmt)) {
        try {
            $db->query($stmt);
            $db->execute();
            echo "Executed: " . substr($stmt, 0, 50) . "...\n";
        } catch (Exception $e) {
            echo "Error executing: " . substr($stmt, 0, 50) . "...\n";
            echo "Message: " . $e->getMessage() . "\n";
        }
    }
}
echo "Migration Completed.\n";
