<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// Check config availability
if (!file_exists('../app/config/config.php')) die("Error: Config file not found.");
require_once '../app/config/config.php';

require_once '../app/includes/functions.php';
require_once '../app/middleware/AuthMiddleware.php';
require_once '../app/core/Database.php';
require_once '../app/core/Database.php';
require_once '../app/core/Controller.php';
require_once '../app/middleware/ServerMiddleware.php';

// Server Management Check (Maintenance & Traffic)
ServerMiddleware::checkMatrix();

// Simple Routing Logic
$url = isset($_GET['url']) ? $_GET['url'] : 'auth/login';
$url = rtrim($url, '/');
$url = filter_var($url, FILTER_SANITIZE_URL);
$url = explode('/', $url);

// Default Controller
$currentController = 'AuthController';
$currentMethod = ''; // Will be set based on controller type
$params = [];

// Check if controller exists
if (isset($url[0])) {
    $ucName = ucwords($url[0]);
    if (file_exists('../app/controllers/' . $ucName . '.php')) {
        $currentController = $ucName;
        unset($url[0]);
    } else if (file_exists('../app/controllers/' . $ucName . 'Controller.php')) {
         $currentController = $ucName . 'Controller';
         unset($url[0]);
    }
}

if (!file_exists('../app/controllers/' . $currentController . '.php')) {
    die("Error: Controller file ../app/controllers/" . $currentController . ".php not found.");
}

require_once '../app/controllers/' . $currentController . '.php';

if (!class_exists($currentController)) {
    die("Error: Class " . $currentController . " not found.");
}

$controller = new $currentController;

// Set default method based on controller type
if ($currentController == 'AuthController') {
    $currentMethod = 'login';
} else {
    $currentMethod = 'dashboard';
}

// Check if method exists
if (isset($url[1])) {
    if (method_exists($controller, $url[1])) {
        $currentMethod = $url[1];
        unset($url[1]);
    }
}

// Get Params
$params = $url ? array_values($url) : [];

// Call the method
call_user_func_array([$controller, $currentMethod], $params);
