<?php
require_once __DIR__ . '/../app/config/config.php';
require_once __DIR__ . '/../app/core/Database.php';

try {
    $db = new Database();
    $sql = file_get_contents(__DIR__ . '/../database/migration_server_management.sql');
    
    // Split by semicolon to execute multiple statements if PDO doesn't support multiple at once nicely (though logic usually does)
    // But since Database class uses prepare/execute, raw multi-query might be tricky if not enabled.
    // Let's manually run raw PDO if possible or just use existing db.
    
    // Using raw PDO from Database class assumption (usually it has private db handler)
    // Actually, let's just use a new PDO instance for migration to be safe and simple
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $statements = array_filter(array_map('trim', explode(';', $sql)));

    foreach ($statements as $stmt) {
        if (!empty($stmt)) {
            $pdo->exec($stmt);
            echo "Executed: " . substr($stmt, 0, 50) . "...\n";
        }
    }
    echo "Migration completed successfully!";
} catch (Exception $e) {
    if (strpos($e->getMessage(), "Duplicate column name") !== false) {
        echo "Migration already applied (Column exists). Moving on.\n";
    } else {
        echo "Error: " . $e->getMessage();
        exit(1);
    }
}
