<?php
// Migration script for violation_logs table
require_once 'app/config/config.php';

// Connect to database
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "Connected to database successfully\n\n";

// Read SQL file
$sql_file = 'update_schema_violation_logs.sql';
$sql = file_get_contents($sql_file);

if (!$sql) {
    die("Failed to read SQL file: $sql_file\n");
}

echo "Executing migration from: $sql_file\n";
echo "===========================================\n\n";

// Split SQL into individual statements
$statements = array_filter(array_map('trim', explode(';', $sql)));

$success_count = 0;
$error_count = 0;

foreach ($statements as $statement) {
    if (empty($statement)) continue;
    
    echo "Executing: " . substr($statement, 0, 100) . "...\n";
    
    if ($conn->query($statement)) {
        echo "✓ Success\n\n";
        $success_count++;
    } else {
        // Check if error is "table already exists" or "column already exists"
        if (strpos($conn->error, 'already exists') !== false || 
            strpos($conn->error, 'Duplicate column') !== false) {
            echo "⚠ Already exists (skipped)\n\n";
            $success_count++;
        } else {
            echo "✗ Error: " . $conn->error . "\n\n";
            $error_count++;
        }
    }
}

echo "===========================================\n";
echo "Migration completed!\n";
echo "Success: $success_count statements\n";
echo "Errors: $error_count statements\n";

// Verify tables
echo "\n===========================================\n";
echo "Verifying tables...\n\n";

// Check violation_logs table
$result = $conn->query("SHOW TABLES LIKE 'violation_logs'");
if ($result->num_rows > 0) {
    echo "✓ violation_logs table exists\n";
    
    // Show structure
    $structure = $conn->query("DESCRIBE violation_logs");
    echo "\nTable structure:\n";
    while ($row = $structure->fetch_assoc()) {
        echo "  - {$row['Field']} ({$row['Type']})\n";
    }
} else {
    echo "✗ violation_logs table not found\n";
}

// Check exam_participants columns
$result = $conn->query("DESCRIBE exam_participants");
echo "\n✓ exam_participants columns:\n";
while ($row = $result->fetch_assoc()) {
    echo "  - {$row['Field']} ({$row['Type']})\n";
}

$conn->close();
echo "\n✓ Migration script completed!\n";
?>
