-- Migration for Advanced Question Types
-- 1. Add Type and Image to questions table
ALTER TABLE questions ADD COLUMN type ENUM('pilihan_ganda', 'pilihan_ganda_kompleks', 'menjodohkan', 'isian_singkat', 'uraian') DEFAULT 'pilihan_ganda' AFTER exam_id;
ALTER TABLE questions ADD COLUMN question_image VARCHAR(255) NULL AFTER question_text;

-- 2. Create flexible Options table (replaces flat columns for new types)
-- For 'menjodohkan', option_text is Key, pair_text is Value.
CREATE TABLE question_options (
    id INT AUTO_INCREMENT PRIMARY KEY,
    question_id INT NOT NULL,
    option_text TEXT,
    option_image VARCHAR(255) NULL,
    is_correct TINYINT(1) DEFAULT 0,
    pair_text TEXT NULL, -- For matching pairs (the "right" side)
    pair_image VARCHAR(255) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (question_id) REFERENCES questions(id) ON DELETE CASCADE
);

-- Note: We will keep existing option_a...option_e columns for backward compatibility 
-- or migrate data later. New code will prefer question_options table.
