-- Part 2: Create Options Table (Run this if Part 1 failed due to duplicate columns)
CREATE TABLE IF NOT EXISTS question_options (
    id INT AUTO_INCREMENT PRIMARY KEY,
    question_id INT NOT NULL,
    option_text TEXT,
    option_image VARCHAR(255) NULL,
    is_correct TINYINT(1) DEFAULT 0,
    pair_text TEXT NULL, -- For matching pairs (the "right" side)
    pair_image VARCHAR(255) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (question_id) REFERENCES questions(id) ON DELETE CASCADE
);
