-- Migration: Add Violation Tracking System
-- Created: 2026-01-17
-- Purpose: Track all exam violations with detailed logging

-- Create violation logs table for detailed tracking
CREATE TABLE IF NOT EXISTS `violation_logs` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `participant_id` INT NOT NULL,
    `violation_type` VARCHAR(100) NOT NULL,
    `violation_details` TEXT,
    `timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `ip_address` VARCHAR(45),
    `user_agent` TEXT,
    FOREIGN KEY (`participant_id`) REFERENCES `exam_participants`(`id`) ON DELETE CASCADE,
    INDEX `idx_participant` (`participant_id`),
    INDEX `idx_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add violation tracking columns to exam_participants
-- Note: Script will handle "duplicate column" errors gracefully
ALTER TABLE `exam_participants` 
ADD COLUMN `violation_count` INT DEFAULT 0 AFTER `ban_reason`;

ALTER TABLE `exam_participants`
ADD COLUMN `first_violation_time` DATETIME DEFAULT NULL AFTER `violation_count`;

-- Add index for better query performance
ALTER TABLE `exam_participants` 
ADD INDEX `idx_status` (`status`);
