<?php
// Proteksi halaman
include 'auth_check.php';
include '../config/koneksi.php';

// Judul Halaman
$page_title = "Dashboard";
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title; ?> - Sistem Informasi Desa</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Admin Specific Styles -->
    <style>
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        .sidebar {
            width: 250px;
            background-color: var(--primary-color);
            color: var(--white);
            display: flex;
            flex-direction: column;
        }
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
            flex: 1;
        }
        .sidebar-menu li a {
            display: block;
            padding: 15px 20px;
            color: #ecf0f1;
            text-decoration: none;
            transition: background 0.3s;
        }
        .sidebar-menu li a:hover, .sidebar-menu li a.active {
            background-color: var(--accent-color);
        }
        .sidebar-menu li a i {
            width: 25px;
        }
        .main-content {
            flex: 1;
            background-color: #f4f6f9;
            padding: 30px;
        }
        .top-bar {
            background-color: var(--white);
            padding: 15px 30px;
            border-radius: 5px;
            box-shadow: var(--shadow);
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        .dashboard-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        .d-card {
            background: var(--white);
            padding: 25px;
            border-radius: 10px;
            box-shadow: var(--shadow);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .d-card-info h3 {
            font-size: 2rem;
            margin-bottom: 5px;
            color: var(--primary-color);
        }
        .d-card-info p {
            color: #777;
        }
        .d-card-icon {
            font-size: 2.5rem;
            color: #ddd;
        }
        .welcome-box {
            margin-top: 30px; 
            background: white; 
            padding: 30px; 
            border-radius: 10px; 
            box-shadow: var(--shadow);
        }
    </style>
</head>
<body>

<div class="admin-container">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>
        <ul class="sidebar-menu">
            <li><a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="kelola_profil.php"><i class="fas fa-info-circle"></i> Profil Desa</a></li>
            <li><a href="kelola_perangkat.php"><i class="fas fa-users-cog"></i> Perangkat Desa</a></li>
            <li><a href="kelola_potensi.php"><i class="fas fa-landmark"></i> Potensi Desa</a></li>
            <li><a href="kelola_berita.php"><i class="fas fa-newspaper"></i> Berita</a></li>
            <li><a href="kelola_galeri.php"><i class="fas fa-images"></i> Galeri</a></li>
            <li><a href="kelola_slider.php"><i class="fas fa-desktop"></i> Kelola Slider</a></li>
            <li><a href="pengaturan_akun.php"><i class="fas fa-user-cog"></i> Pengaturan Akun</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="top-bar">
            <h2><?= $page_title; ?></h2>
            <div class="user-info">
                Halo, <strong><?= $_SESSION['fullname']; ?></strong>
            </div>
        </div>

        <div class="dashboard-cards">
            <!-- Card Berita -->
            <div class="d-card">
                <div class="d-card-info">
                    <?php $jml_berita = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM berita")); ?>
                    <h3><?= $jml_berita; ?></h3>
                    <p>Total Berita</p>
                </div>
                <div class="d-card-icon">
                    <i class="fas fa-newspaper"></i>
                </div>
            </div>

            <!-- Card Potensi -->
            <div class="d-card">
                <div class="d-card-info">
                    <?php $jml_potensi = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM potensi_desa")); ?>
                    <h3><?= $jml_potensi; ?></h3>
                    <p>Potensi Desa</p>
                </div>
                <div class="d-card-icon">
                    <i class="fas fa-landmark"></i>
                </div>
            </div>

            <!-- Card Galeri -->
            <div class="d-card">
                <div class="d-card-info">
                    <?php $jml_galeri = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM galeri")); ?>
                    <h3><?= $jml_galeri; ?></h3>
                    <p>Foto Galeri</p>
                </div>
                <div class="d-card-icon">
                    <i class="fas fa-images"></i>
                </div>
            </div>
        </div>

        <div class="welcome-box">
            <h3>Selamat Datang di Halaman Administrator</h3>
            <p>Anda login sebagai <strong><?= $_SESSION['username']; ?></strong>. Gunakan menu di samping untuk mengelola konten website.</p>
        </div>
    </div>
</div>

</body>
</html>
