<?php
include 'auth_check.php';
include '../config/koneksi.php';

$page_title = "Kelola Berita";

// Hapus Data
if (isset($_GET['hapus'])) {
    $id = (int)$_GET['hapus'];
    // Ambil data gambar lama
    $q_img = mysqli_query($koneksi, "SELECT gambar FROM berita WHERE id_berita = '$id'");
    $r_img = mysqli_fetch_assoc($q_img);
    if ($r_img['gambar'] != '' && file_exists("../uploads/berita/" . $r_img['gambar'])) {
        unlink("../uploads/berita/" . $r_img['gambar']);
    }

    $delete = mysqli_query($koneksi, "DELETE FROM berita WHERE id_berita = '$id'");
    if ($delete) {
        echo "<script>alert('Berita berhasil dihapus!'); window.location='kelola_berita.php';</script>";
    } else {
        echo "<script>alert('Gagal menghapus berita!');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title; ?> - Admin Dashboard</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .admin-container { display: flex; min-height: 100vh; }
        .sidebar { width: 250px; background-color: var(--primary-color); color: var(--white); display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .sidebar-menu { list-style: none; padding: 20px 0; flex: 1; }
        .sidebar-menu li a { display: block; padding: 15px 20px; color: #ecf0f1; text-decoration: none; transition: background 0.3s; }
        .sidebar-menu li a:hover, .sidebar-menu li a.active { background-color: var(--accent-color); }
        .sidebar-menu li a i { width: 25px; }
        .main-content { flex: 1; background-color: #f4f6f9; padding: 30px; }

        .card-table { background: var(--white); padding: 20px; border-radius: 10px; box-shadow: var(--shadow); }
        .table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .table th, .table td { padding: 12px; border-bottom: 1px solid #ddd; text-align: left; }
        .table th { background-color: #f8f9fa; color: var(--primary-color); }
        .btn-action { padding: 5px 10px; border-radius: 4px; text-decoration: none; font-size: 0.9rem; color: white; display: inline-block; }
        .btn-edit { background-color: #ffc107; color: #000; }
        .btn-delete { background-color: #dc3545; }
        .btn-add { background-color: var(--accent-color); color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; }
        .img-thumb { width: 80px; height: 50px; object-fit: cover; border-radius: 4px; }
    </style>
</head>
<body>

<div class="admin-container">
    <div class="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>
        <ul class="sidebar-menu">
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="kelola_profil.php"><i class="fas fa-info-circle"></i> Profil Desa</a></li>
            <li><a href="kelola_perangkat.php"><i class="fas fa-users-cog"></i> Perangkat Desa</a></li>
            <li><a href="kelola_potensi.php"><i class="fas fa-landmark"></i> Potensi Desa</a></li>
            <li><a href="kelola_berita.php" class="active"><i class="fas fa-newspaper"></i> Berita</a></li>
            <li><a href="kelola_galeri.php"><i class="fas fa-images"></i> Galeri</a></li>
            <li><a href="kelola_slider.php"><i class="fas fa-desktop"></i> Kelola Slider</a></li>
            <li><a href="pengaturan_akun.php"><i class="fas fa-user-cog"></i> Pengaturan Akun</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="card-table">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h2>Kelola Berita</h2>
                <a href="form_berita.php" class="btn-add"><i class="fas fa-plus"></i> Tulis Berita</a>
            </div>
            
            <table class="table">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Gambar</th>
                        <th>Judul</th>
                        <th>Tgl Terbit</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = 1;
                    $query = mysqli_query($koneksi, "SELECT * FROM berita ORDER BY tanggal_terbit DESC, created_at DESC");
                    while ($data = mysqli_fetch_assoc($query)) {
                    ?>
                    <tr>
                        <td><?= $no++; ?></td>
                        <td>
                            <?php if ($data['gambar'] != '' && file_exists("../uploads/berita/" . $data['gambar'])): ?>
                                <img src="../uploads/berita/<?= $data['gambar']; ?>" class="img-thumb">
                            <?php else: ?>
                                <span class="text-muted">No Image</span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars(substr($data['judul'], 0, 50)); ?>...</td>
                        <td><?= date('d/m/Y', strtotime($data['tanggal_terbit'])); ?></td>
                        <td>
                            <a href="form_berita.php?id=<?= $data['id_berita']; ?>" class="btn-action btn-edit"><i class="fas fa-edit"></i> Edit</a>
                            <a href="?hapus=<?= $data['id_berita']; ?>" class="btn-action btn-delete" onclick="return confirm('Yakin ingin menghapus berita ini?')"><i class="fas fa-trash"></i> Hapus</a>
                        </td>
                    </tr>
                    <?php } ?>
                    
                    <?php if (mysqli_num_rows($query) == 0): ?>
                    <tr>
                        <td colspan="5" style="text-align: center;">Belum ada berita.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

</body>
</html>
