<?php
include 'auth_check.php';
include '../config/koneksi.php';
include '../config/functions.php';

$page_title = "Kelola Slider Beranda";
$message = "";
$message_type = "";

// 1. Upload Slider
if (isset($_POST['upload_slider'])) {
    if (isset($_FILES['slider_img']['error']) && $_FILES['slider_img']['error'] === 0) {
        $upload = uploadImage($_FILES['slider_img'], "../uploads/slider/");
        if (strpos($upload, ' ') !== false) {
             // Error
             $message = "Gagal upload slider: " . $upload;
             $message_type = "error";
        } else {
            // Success upload, insert to DB
            $id_admin = $_SESSION['id_admin'];
            $q_slide = "INSERT INTO slider (gambar, id_admin) VALUES ('$upload', '$id_admin')";
            if(mysqli_query($koneksi, $q_slide)) {
                $message = "Gambar slider berhasil ditambahkan!";
                $message_type = "success";
            } else {
                $message = "Gagal simpan ke database: " . mysqli_error($koneksi);
                $message_type = "error";
            }
        }
    } else {
        $message = "Pilih file gambar terlebih dahulu.";
        $message_type = "error";
    }
}

// 2. Hapus Slider
if (isset($_GET['hapus_slider'])) {
    $id_slider = (int)$_GET['hapus_slider'];
    // Ambil info gambar
    $q_s = mysqli_query($koneksi, "SELECT gambar FROM slider WHERE id_slider = '$id_slider'");
    if(mysqli_num_rows($q_s) > 0){
        $d_s = mysqli_fetch_assoc($q_s);
        // Hapus file
        if ($d_s['gambar'] != '' && file_exists("../uploads/slider/" . $d_s['gambar'])) {
            unlink("../uploads/slider/" . $d_s['gambar']);
        }
        // Hapus DB
        mysqli_query($koneksi, "DELETE FROM slider WHERE id_slider = '$id_slider'");
        echo "<script>alert('Slider berhasil dihapus!'); window.location='kelola_slider.php';</script>";
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title; ?> - Admin Dashboard</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .admin-container { display: flex; min-height: 100vh; }
        .sidebar { width: 250px; background-color: var(--primary-color); color: var(--white); display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .sidebar-menu { list-style: none; padding: 20px 0; flex: 1; }
        .sidebar-menu li a { display: block; padding: 15px 20px; color: #ecf0f1; text-decoration: none; transition: background 0.3s; }
        .sidebar-menu li a:hover, .sidebar-menu li a.active { background-color: var(--accent-color); }
        .sidebar-menu li a i { width: 25px; }
        .main-content { flex: 1; background-color: #f4f6f9; padding: 30px; }
        
        .card-form { background: var(--white); padding: 30px; border-radius: 10px; box-shadow: var(--shadow); }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: bold; color: var(--primary-color); }
        .form-control { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 1rem; }
        .btn-save { background-color: var(--accent-color); color: white; padding: 10px 25px; border: none; border-radius: 5px; cursor: pointer; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-success { background-color: #d4edda; color: #155724; }
        .alert-error { background-color: #f8d7da; color: #721c24; }
    </style>
</head>
<body>

<div class="admin-container">
    <div class="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>
        <ul class="sidebar-menu">
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="kelola_profil.php"><i class="fas fa-info-circle"></i> Profil Desa</a></li>
            <li><a href="kelola_perangkat.php"><i class="fas fa-users-cog"></i> Perangkat Desa</a></li>
            <li><a href="kelola_potensi.php"><i class="fas fa-landmark"></i> Potensi Desa</a></li>
            <li><a href="kelola_berita.php"><i class="fas fa-newspaper"></i> Berita</a></li>
            <li><a href="kelola_galeri.php"><i class="fas fa-images"></i> Galeri</a></li>
            <li><a href="kelola_slider.php" class="active"><i class="fas fa-desktop"></i> Kelola Slider</a></li>
            <li><a href="pengaturan_akun.php"><i class="fas fa-user-cog"></i> Pengaturan Akun</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <!-- === Bagian Slider Beranda === -->
        <div class="card-form">
            <h2 style="margin-bottom: 20px;">Kelola Slider Beranda</h2>
            
             <?php if (!empty($message)): ?>
                <div class="alert <?= ($message_type == 'success') ? 'alert-success' : 'alert-error'; ?>">
                    <?= $message; ?>
                </div>
            <?php endif; ?>

            <p style="margin-bottom: 20px; color: #666;">Upload gambar untuk background slider di halaman depan. (Disarankan ukuran resolusi tinggi landscape, misal 1920x1080)</p>
            
            <!-- Form Upload -->
            <form action="" method="POST" enctype="multipart/form-data" style="margin-bottom: 30px; border-bottom: 1px solid #eee; padding-bottom: 20px;">
                <div class="form-group">
                    <label>Tambah Gambar Baru</label>
                    <div style="display: flex; gap: 10px;">
                        <input type="file" name="slider_img" class="form-control" accept="image/*" required>
                        <button type="submit" name="upload_slider" class="btn-save"><i class="fas fa-upload"></i> Upload</button>
                    </div>
                </div>
            </form>

            <!-- List Gambar -->
            <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 20px;">
                <?php
                $q_slider = mysqli_query($koneksi, "SELECT * FROM slider ORDER BY created_at DESC");
                if (mysqli_num_rows($q_slider) > 0) {
                    while($row_s = mysqli_fetch_assoc($q_slider)) {
                        ?>
                        <div style="position: relative; border-radius: 5px; overflow: hidden; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
                            <?php if(file_exists("../uploads/slider/" . $row_s['gambar'])): ?>
                                <img src="../uploads/slider/<?= $row_s['gambar']; ?>" style="width: 100%; height: 150px; object-fit: cover; display: block;">
                            <?php else: ?>
                                <div style="height: 150px; background: #eee; display: flex; align-items: center; justify-content: center; color: #999;">File Missing</div>
                            <?php endif; ?>
                            
                            <div style="padding: 10px; background: white; text-align: center;">
                                <a href="?hapus_slider=<?= $row_s['id_slider']; ?>" onclick="return confirm('Hapus gambar slider ini?')" style="color: red; text-decoration: none; font-weight: bold;">
                                    <i class="fas fa-trash"></i> Hapus
                                </a>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    echo "<p style='grid-column: 1/-1; text-align: center; color: #777;'>Belum ada gambar slider.</p>";
                }
                ?>
            </div>
        </div>
    </div>
</div>

</body>
</html>
