<?php
session_start();
require_once '../config/koneksi.php';

// Jika sudah login, redirect ke dashboard
if (isset($_SESSION['status']) && $_SESSION['status'] == 'login') {
    header("Location: index.php");
    exit;
}

$error_msg = "";

include '../config/functions.php'; // Include functions

// ...

if (isset($_POST['login'])) {
    $username = cleanInput($_POST['username']);
    $password = cleanInput($_POST['password']);

    // Cek username
    $query = mysqli_query($koneksi, "SELECT * FROM admin WHERE username = '$username'");
    $cek = mysqli_num_rows($query);

    if ($cek > 0) {
        $data = mysqli_fetch_assoc($query);
        // Verifikasi password hash
        if (password_verify($password, $data['password'])) {
            // Set Session
            $_SESSION['id_admin'] = $data['id_admin'];
            $_SESSION['username'] = $data['username'];
            $_SESSION['fullname'] = $data['fullname'];
            $_SESSION['status']   = 'login';

            // Redirect ke dashboard
            header("Location: index.php");
            exit;
        } else {
            $error_msg = "Password salah!";
        }
    } else {
        $error_msg = "Username tidak ditemukan!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Administrator - Sistem Informasi Desa</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="login-body">

    <div class="login-container">
        <div class="login-header">
            <i class="fas fa-user-shield"></i>
            <h2>Admin Login</h2>
            <p>Silakan masuk untuk mengelola data</p>
        </div>

        <?php if ($error_msg): ?>
            <div class="alert-error">
                <i class="fas fa-exclamation-circle"></i> <?= $error_msg; ?>
            </div>
        <?php endif; ?>

        <form action="" method="POST" class="login-form">
            <div class="form-group">
                <label for="username">Username</label>
                <div class="input-icon">
                    <i class="fas fa-user"></i>
                    <input type="text" name="username" id="username" placeholder="Masukkan Username" required autofocus>
                </div>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <input type="password" name="password" id="password" placeholder="Masukkan Password" required>
                </div>
            </div>

            <button type="submit" name="login" class="btn-login-full">Login</button>
        </form>

        <div class="login-footer">
            <a href="../index.php"><i class="fas fa-arrow-left"></i> Kembali ke Halaman Depan</a>
        </div>
    </div>

</body>
</html>
