<?php
include 'auth_check.php';
include '../config/koneksi.php';
include '../config/functions.php';

$page_title = "Pengaturan Akun";
$message = "";
$message_type = "";
$id_admin = $_SESSION['id_admin'];

// Ambil Data Admin
$query = mysqli_query($koneksi, "SELECT * FROM admin WHERE id_admin = '$id_admin'");
$data = mysqli_fetch_assoc($query);

// Update Akun
if (isset($_POST['simpan'])) {
    $username = cleanInput($_POST['username']);
    $fullname = cleanInput($_POST['fullname']);
    $password_baru = cleanInput($_POST['password_baru']);
    
    if (empty($username) || empty($fullname)) {
        $message = "Username dan Nama Lengkap wajib diisi!";
        $message_type = "error";
    } else {
        // Cek username unik (jika ganti username)
        if ($username != $data['username']) {
            $cek = mysqli_query($koneksi, "SELECT * FROM admin WHERE username = '$username'");
            if (mysqli_num_rows($cek) > 0) {
                $message = "Username sudah digunakan!";
                $message_type = "error";
            }
        }
        
        if ($message == "") {
            $update_sql = "UPDATE admin SET username = '$username', fullname = '$fullname'";
            
            // Jika ada perubahan password
            if (!empty($password_baru)) {
                $hashed_password = password_hash($password_baru, PASSWORD_DEFAULT);
                $update_sql .= ", password = '$hashed_password'";
            }
            
            $update_sql .= " WHERE id_admin = '$id_admin'";
            
            if (mysqli_query($koneksi, $update_sql)) {
                $message = "Profil akun berhasil diperbarui!";
                $message_type = "success";
                
                // Update Session
                $_SESSION['username'] = $username;
                $_SESSION['fullname'] = $fullname;
                
                // Refresh data
                $data = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM admin WHERE id_admin = '$id_admin'"));
            } else {
                $message = "Gagal simpan akun: " . mysqli_error($koneksi);
                $message_type = "error";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title; ?> - Admin Dashboard</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .admin-container { display: flex; min-height: 100vh; }
        .sidebar { width: 250px; background-color: var(--primary-color); color: var(--white); display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .sidebar-menu { list-style: none; padding: 20px 0; flex: 1; }
        .sidebar-menu li a { display: block; padding: 15px 20px; color: #ecf0f1; text-decoration: none; transition: background 0.3s; }
        .sidebar-menu li a:hover, .sidebar-menu li a.active { background-color: var(--accent-color); }
        .sidebar-menu li a i { width: 25px; }
        .main-content { flex: 1; background-color: #f4f6f9; padding: 30px; }
        
        .card-form { background: var(--white); padding: 30px; border-radius: 10px; box-shadow: var(--shadow); max-width: 600px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: bold; color: var(--primary-color); }
        .form-control { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 1rem; }
        .btn-save { background-color: var(--accent-color); color: white; padding: 10px 25px; border: none; border-radius: 5px; cursor: pointer; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-success { background-color: #d4edda; color: #155724; }
        .alert-error { background-color: #f8d7da; color: #721c24; }
    </style>
</head>
<body>

<div class="admin-container">
    <div class="sidebar">
        <div class="sidebar-header">
            <h3>Admin Panel</h3>
        </div>
        <ul class="sidebar-menu">
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="kelola_profil.php"><i class="fas fa-info-circle"></i> Profil Desa</a></li>
            <li><a href="kelola_perangkat.php"><i class="fas fa-users-cog"></i> Perangkat Desa</a></li>
            <li><a href="kelola_potensi.php"><i class="fas fa-landmark"></i> Potensi Desa</a></li>
            <li><a href="kelola_berita.php"><i class="fas fa-newspaper"></i> Berita</a></li>
            <li><a href="kelola_galeri.php"><i class="fas fa-images"></i> Galeri</a></li>
            <li><a href="kelola_slider.php"><i class="fas fa-desktop"></i> Kelola Slider</a></li>
            <li><a href="pengaturan_akun.php" class="active"><i class="fas fa-user-cog"></i> Pengaturan Akun</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="card-form">
            <h2 style="margin-bottom: 20px;">Pengaturan Akun</h2>
            
             <?php if (!empty($message)): ?>
                <div class="alert <?= ($message_type == 'success') ? 'alert-success' : 'alert-error'; ?>">
                    <?= $message; ?>
                </div>
            <?php endif; ?>

            <form action="" method="POST">
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($data['username']); ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" name="fullname" class="form-control" value="<?= htmlspecialchars($data['fullname']); ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Password Baru (Kosongkan jika tidak ingin mengubah)</label>
                    <input type="password" name="password_baru" class="form-control" placeholder="Masukkan password baru...">
                </div>

                <button type="submit" name="simpan" class="btn-save"><i class="fas fa-save"></i> Simpan Perubahan</button>
            </form>
        </div>
    </div>
</div>

</body>
</html>
