<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Konfigurasi Pagination
$jumlah_data_per_halaman = 6;
$jumlah_data = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM berita"));
$jumlah_halaman = ceil($jumlah_data / $jumlah_data_per_halaman);
$halaman_aktif = (isset($_GET['halaman'])) ? $_GET['halaman'] : 1;
$awal_data = ($jumlah_data_per_halaman * $halaman_aktif) - $jumlah_data_per_halaman;

// Query Data Berita
$query = mysqli_query($koneksi, "SELECT * FROM berita ORDER BY tanggal_terbit DESC LIMIT $awal_data, $jumlah_data_per_halaman");
?>

<div class="page-header">
    <div class="container">
        <h1>Berita Desa</h1>
    </div>
</div>

<div class="container main-content">
    <?php if (mysqli_num_rows($query) > 0): ?>
        <div class="berita-grid">
            <?php while ($row = mysqli_fetch_assoc($query)): ?>
                <div class="card-berita">
                    <div class="berita-img">
                        <?php 
                        $img_path = "uploads/berita/" . $row['gambar'];
                        $img_tampil = (file_exists($img_path) && $row['gambar'] != '') ? $img_path : "https://via.placeholder.com/600x400?text=Berita+Desa";
                        ?>
                        <img src="<?= $img_tampil; ?>" alt="<?= htmlspecialchars($row['judul']); ?>">
                        <div class="tanggal-badge">
                            <i class="far fa-calendar-alt"></i> <?= date('d M Y', strtotime($row['tanggal_terbit'])); ?>
                        </div>
                    </div>
                    <div class="berita-body">
                        <h3><a href="detail_berita.php?id=<?= $row['id_berita']; ?>"><?= htmlspecialchars($row['judul']); ?></a></h3>
                        <p><?= htmlspecialchars(substr(strip_tags($row['konten']), 0, 100)) . '...'; ?></p>
                        <a href="detail_berita.php?id=<?= $row['id_berita']; ?>" class="btn-read">Baca Selengkapnya</a>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>

        <!-- Pagination -->
        <?php if ($jumlah_halaman > 1): ?>
            <div class="pagination">
                <?php if ($halaman_aktif > 1): ?>
                    <a href="?halaman=<?= $halaman_aktif - 1; ?>">&laquo; Sebelumnya</a>
                <?php endif; ?>

                <?php for ($i = 1; $i <= $jumlah_halaman; $i++): ?>
                    <?php if ($i == $halaman_aktif): ?>
                        <a href="?halaman=<?= $i; ?>" class="active"><?= $i; ?></a>
                    <?php else: ?>
                        <a href="?halaman=<?= $i; ?>"><?= $i; ?></a>
                    <?php endif; ?>
                <?php endfor; ?>

                <?php if ($halaman_aktif < $jumlah_halaman): ?>
                    <a href="?halaman=<?= $halaman_aktif + 1; ?>">Selanjutnya &raquo;</a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

    <?php else: ?>
        <div class="alert-info text-center">
            <p>Belum ada berita terbaru.</p>
        </div>
    <?php endif; ?>
</div>

<?php
include 'includes/footer.php';
?>
