<?php
// Function untuk sanitasi input
function cleanInput($data) {
    global $koneksi;
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    // Tambahan: mysqli escape string
    $data = mysqli_real_escape_string($koneksi, $data);
    return $data;
}

// Function untuk validasi dan upload gambar yang aman
// Mengembalikan nama file baru jika sukses, atau pesan error (string) jika gagal
function uploadImage($file_input, $target_dir, $max_size = 2000000) {
    // 1. Cek apakah ada file yang diupload atau error
    if ($file_input['error'] === 4) {
        return "no_file"; // Tidak ada file yang diupload
    }
    
    // 2. Cek apakah foto valid
    $check = getimagesize($file_input["tmp_name"]);
    if($check === false) {
        return "File bukan gambar.";
    }

    // 3. Cek ukuran file (default 2MB)
    if ($file_input["size"] > $max_size) {
        return "Ukuran file terlalu besar (Maks 2MB).";
    }

    // 4. Cek ekstensi file (Whitelist)
    $imageFileType = strtolower(pathinfo($file_input["name"], PATHINFO_EXTENSION));
    $allowed_types = ['jpg', 'jpeg', 'png', 'gif'];
    if(!in_array($imageFileType, $allowed_types)) {
        return "Hanya format JPG, JPEG, PNG, & GIF yang diperbolehkan.";
    }

    // 5. Generate nama file baru yang unik
    $new_filename = uniqid() . '.' . $imageFileType;
    $target_file = $target_dir . $new_filename;

    // Pastikan folder tujuan ada
    if (!file_exists($target_dir)) {
        if (!mkdir($target_dir, 0777, true)) {
            return "Gagal membuat folder upload: $target_dir";
        }
    }

    // 6. Upload file
    if (move_uploaded_file($file_input["tmp_name"], $target_file)) {
        return $new_filename; // Sukses, kembalikan nama file
    } else {
        return "Gagal upload. Folder: $target_dir, Error: " . error_get_last()['message'];
    }
}
?>
