<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Ambil ID dari URL
$id_berita = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Query Data Berita
$query = mysqli_query($koneksi, "SELECT berita.*, admin.fullname 
                                 FROM berita 
                                 LEFT JOIN admin ON berita.id_admin = admin.id_admin 
                                 WHERE id_berita = '$id_berita'");
$d = mysqli_fetch_assoc($query);

// Jika data tidak ditemukan
if (!$d) {
    echo "<script>alert('Berita tidak ditemukan!'); window.location='berita.php';</script>";
    exit;
}
?>

<div class="page-header">
    <div class="container">
        <h1>Berita Desa</h1>
    </div>
</div>

<div class="container main-content">
    <div class="detail-berita-wrapper">
        <div class="berita-header">
            <h1><?= htmlspecialchars($d['judul']); ?></h1>
            <div class="meta-info">
                <span><i class="far fa-user"></i> <?= htmlspecialchars($d['fullname']); ?></span>
                <span><i class="far fa-calendar-alt"></i> <?= date('d M Y', strtotime($d['tanggal_terbit'])); ?></span>
            </div>
        </div>

        <div class="berita-image-full">
            <?php 
            $img_path = "uploads/berita/" . $d['gambar'];
            $img_tampil = (file_exists($img_path) && $d['gambar'] != '') ? $img_path : "https://via.placeholder.com/800x400?text=Berita+Desa";
            ?>
            <img src="<?= $img_tampil; ?>" alt="<?= htmlspecialchars($d['judul']); ?>">
        </div>

        <div class="berita-content">
            <?= nl2br($d['konten']); // Menggunakan nl2br sementara, nanti bisa diganti output text editor jika ada ?>
        </div>

        <div class="berita-footer">
            <a href="berita.php" class="btn-back"><i class="fas fa-arrow-left"></i> Kembali ke Daftar Berita</a>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>
