<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Ambil ID dari URL
$id_potensi = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Query Data
$query = mysqli_query($koneksi, "SELECT * FROM potensi_desa WHERE id_potensi = '$id_potensi'");
$d = mysqli_fetch_assoc($query);

// Jika data tidak ditemukan
if (!$d) {
    echo "<script>alert('Data potensi tidak ditemukan!'); window.location='potensi.php';</script>";
    exit;
}
?>

<div class="page-header">
    <div class="container">
        <h1>Potensi Desa</h1>
    </div>
</div>

<div class="container main-content">
    <div class="detail-berita-wrapper"> <!-- Reuse style detail berita -->
        <div class="berita-header">
            <h1><?= htmlspecialchars($d['judul']); ?></h1>
            <div class="meta-info">
                <span><i class="fas fa-tag"></i> Kategori: <?= htmlspecialchars($d['kategori']); ?></span>
                <span><i class="far fa-calendar-alt"></i> <?= date('d M Y', strtotime($d['created_at'])); ?></span>
            </div>
        </div>

        <div class="berita-image-full">
            <?php 
            $img_path = "uploads/potensi/" . $d['gambar'];
            $img_tampil = (file_exists($img_path) && $d['gambar'] != '') ? $img_path : "https://via.placeholder.com/800x400?text=Potensi+Desa";
            ?>
            <img src="<?= $img_tampil; ?>" alt="<?= htmlspecialchars($d['judul']); ?>">
        </div>

        <div class="berita-content">
            <?= nl2br(htmlspecialchars($d['deskripsi'])); ?>
        </div>

        <div class="berita-footer">
            <a href="potensi.php" class="btn-back"><i class="fas fa-arrow-left"></i> Kembali ke Daftar Potensi</a>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>
