<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Query Data Galeri
$query = mysqli_query($koneksi, "SELECT * FROM galeri ORDER BY created_at DESC");
?>

<div class="page-header">
    <div class="container">
        <h1>Galeri Desa</h1>
    </div>
</div>

<div class="container main-content">
    <div class="section-title text-center">
        <h2>Dokumentasi Kegiatan</h2>
        <p>Potret kegiatan dan keindahan desa kami.</p>
    </div>

    <?php if (mysqli_num_rows($query) > 0): ?>
        <div class="galeri-grid">
            <?php while ($row = mysqli_fetch_assoc($query)): ?>
                <div class="card-galeri">
                    <?php 
                    $img_path = "uploads/galeri/" . $row['file_gambar'];
                    $img_tampil = (file_exists($img_path) && $row['file_gambar'] != '') ? $img_path : "https://via.placeholder.com/600x400?text=Galeri+Desa";
                    ?>
                    <a href="<?= $img_tampil; ?>" target="_blank" class="galeri-item">
                        <img src="<?= $img_tampil; ?>" alt="<?= htmlspecialchars($row['judul']); ?>">
                        <div class="galeri-overlay">
                            <h3><?= htmlspecialchars($row['judul']); ?></h3>
                            <p><?= htmlspecialchars($row['deskripsi']); ?></p>
                        </div>
                    </a>
                </div>
            <?php endwhile; ?>
        </div>
    <?php else: ?>
        <div class="alert-info text-center">
            <p>Belum ada foto di galeri.</p>
        </div>
    <?php endif; ?>
</div>

<?php
include 'includes/footer.php';
?>
