<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Ambil data profil desa
$query_profil = mysqli_query($koneksi, "SELECT * FROM profil_desa LIMIT 1");
$profil = mysqli_fetch_assoc($query_profil);

// Default data jika database kosong
if (!$profil) {
    $profil = [
        'nama_desa' => 'Desa Nusantara',
        'deskripsi' => 'Selamat datang di website resmi Desa Nusantara.',
        'logo' => 'default-logo.png'
    ];
}

// Ambil data statistik (Hitung jumlah baris)
$jml_penduduk  = 1250; // Contoh statis (karena belum ada tabel penduduk)
$jml_perangkat = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM perangkat_desa"));
$jml_berita    = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM berita"));
$jml_potensi   = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM potensi_desa"));
?>

<!-- Hero Banner Section -->
<!-- Hero Banner Section -->
<section class="hero-banner">
    <div class="hero-slider">
        <?php
        // Ambil gambar slider
        $q_slider = mysqli_query($koneksi, "SELECT * FROM slider ORDER BY created_at DESC");
        $slider_count = mysqli_num_rows($q_slider);
        
        if ($slider_count > 0) {
            $i = 0;
            while ($row_s = mysqli_fetch_assoc($q_slider)) {
                $status = ($i == 0) ? 'active' : '';
                // Background image via inline CSS style
                echo '<div class="slide-item ' . $status . '" style="background-image: url(\'uploads/slider/' . $row_s['gambar'] . '\');"></div>';
                $i++;
            }
        } else {
            // Default static image if no slider
            echo '<div class="slide-item active" style="background-image: url(\'assets/img/village-bg.jpg\');"></div>';
        }
        ?>
    </div>
    
    <div class="overlay"></div>
    <div class="container hero-content">
        <h1>Selamat Datang di Website Resmi</h1>
        <h2><?= htmlspecialchars($profil['nama_desa']); ?></h2>
        <p><?= htmlspecialchars(substr($profil['deskripsi'], 0, 150)) . '...'; ?></p>
        <a href="profil.php" class="btn-hero">Selengkapnya <i class="fas fa-arrow-right"></i></a>
    </div>
</section>

<!-- Slider Script -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        let slides = document.querySelectorAll('.slide-item');
        let currentSlide = 0;
        const slideInterval = 5000; // 5 detik

        if (slides.length > 1) {
            setInterval(function() {
                slides[currentSlide].classList.remove('active');
                currentSlide = (currentSlide + 1) % slides.length;
                slides[currentSlide].classList.add('active');
            }, slideInterval);
        }
    });
</script>

<!-- Sambutan Section -->
<section class="section-sambutan">
    <div class="container">
        <div class="sambutan-wrapper">
            <?php
            // Ambil data Kepala Desa (Urutan 1)
            $q_kades = mysqli_query($koneksi, "SELECT * FROM perangkat_desa ORDER BY urutan ASC LIMIT 1");
            $kades = mysqli_fetch_assoc($q_kades);
            ?>
            <div class="sambutan-img">
                <?php if ($kades && $kades['foto'] != '' && file_exists("uploads/perangkat/" . $kades['foto'])): ?>
                    <img src="uploads/perangkat/<?= $kades['foto']; ?>" alt="<?= htmlspecialchars($kades['nama']); ?>">
                <?php else: ?>
                    <img src="assets/img/kades-placeholder.jpg" alt="Kepala Desa" onerror="this.src='https://via.placeholder.com/300x400?text=Foto+Kades'">
                <?php endif; ?>
            </div>
            <div class="sambutan-text">
                <h3>Sambutan <?= $kades ? htmlspecialchars($kades['jabatan']) : 'Kepala Desa'; ?></h3>
                <p>
                    "Assalamu'alaikum Warahmatullahi Wabarakatuh. Puji syukur kita panjatkan ke hadirat Allah SWT, Tuhan Yang Maha Esa. 
                    Website ini hadir sebagai wujud transparansi dan pelayanan informasi kepada seluruh masyarakat <?= htmlspecialchars($profil['nama_desa']); ?>. 
                    Mari bersama memajukan desa kita tercinta."
                </p>
                <cite>- <?= $kades ? htmlspecialchars($kades['nama']) : 'Kepala Desa'; ?></cite>
            </div>
        </div>
    </div>
</section>

<!-- Statistik Desa -->
<section class="section-stats">
    <div class="container">
        <div class="section-title text-center">
            <h2>Statistik Desa</h2>
            <p>Data terkini mengenai <?= htmlspecialchars($profil['nama_desa']); ?></p>
        </div>
        <div class="stats-grid">
            <div class="stat-card">
                <i class="fas fa-users"></i>
                <h3><?= number_format($jml_penduduk); ?></h3>
                <p>Penduduk</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-user-tie"></i>
                <h3><?= number_format($jml_perangkat); ?></h3>
                <p>Perangkat Desa</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-newspaper"></i>
                <h3><?= number_format($jml_berita); ?></h3>
                <p>Berita</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-gem"></i>
                <h3><?= number_format($jml_potensi); ?></h3>
                <p>Potensi Desa</p>
            </div>
        </div>
    </div>
</section>

<?php
include 'includes/footer.php';
?>
