<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Ambil data profil desa untuk kontak
$query = mysqli_query($koneksi, "SELECT nama_desa, alamat, email, telepon, deskripsi FROM profil_desa LIMIT 1");
$data = mysqli_fetch_assoc($query);

// Default jika kosong
if (!$data) {
    $data = [
        'nama_desa' => 'Desa Nusantara',
        'alamat' => 'Jl. Belum Diisi',
        'email' => 'admin@desa.id',
        'telepon' => '-',
        'deskripsi' => ''
    ];
}
?>

<div class="page-header">
    <div class="container">
        <h1>Kontak Kami</h1>
    </div>
</div>

<div class="container main-content">
    <div class="contact-wrapper">
        <div class="contact-info-card">
            <div class="icon-box">
                <i class="fas fa-map-marker-alt"></i>
            </div>
            <h3>Alamat Kantor</h3>
            <p><?= nl2br(htmlspecialchars((string)$data['alamat'])); ?></p>
        </div>

        <div class="contact-info-card">
            <div class="icon-box">
                <i class="fas fa-phone"></i>
            </div>
            <h3>Telepon / WhatsApp</h3>
            <p><?= htmlspecialchars((string)$data['telepon']); ?></p>
        </div>

        <div class="contact-info-card">
            <div class="icon-box">
                <i class="fas fa-envelope"></i>
            </div>
            <h3>Email</h3>
            <p><?= htmlspecialchars((string)$data['email']); ?></p>
        </div>
    </div>

    <!-- Tambahan: Peta Lokasi (Opsional / Placeholder) -->
    <div class="map-section text-center">
        <h2>Lokasi Desa</h2>
        <div class="map-placeholder">
            <p>Peta Google Maps dapat disematkan di sini.</p>
            <small>(Edit file kontak.php untuk menyematkan iframe Google Maps)</small>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>
