<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Ambil data profil desa
$query = mysqli_query($koneksi, "SELECT * FROM profil_desa LIMIT 1");
$data  = mysqli_fetch_assoc($query);

// Data default jika kosong
if (!$data) {
    $data = [
        'nama_desa' => 'Desa Nusantara',
        'sejarah'   => 'Belum ada data sejarah.',
        'visi'      => 'Belum ada data visi.',
        'misi'      => 'Belum ada data misi.',
        'deskripsi' => 'Belum ada deskripsi desa.',
        'alamat'    => '-'
    ];
}
?>

<!-- Banner Header -->
<div class="page-header">
    <div class="container">
        <h1>Profil Desa <?= htmlspecialchars((string)$data['nama_desa']); ?></h1>
    </div>
</div>

<div class="container main-content">
    <div class="profil-section">
        <div class="section-header">
            <i class="fas fa-history"></i>
            <h2>Sejarah Desa</h2>
        </div>
        <div class="content-box">
            <p><?= nl2br(htmlspecialchars((string)$data['sejarah'])); ?></p>
        </div>
    </div>

    <div class="row-visi-misi">
        <div class="col-half">
            <div class="card-visi">
                <div class="card-header">
                    <i class="fas fa-eye"></i>
                    <h3>Visi</h3>
                </div>
                <div class="card-body">
                    <p><?= nl2br(htmlspecialchars((string)$data['visi'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col-half">
            <div class="card-misi">
                <div class="card-header">
                    <i class="fas fa-bullseye"></i>
                    <h3>Misi</h3>
                </div>
                <div class="card-body">
                    <p><?= nl2br(htmlspecialchars((string)$data['misi'])); ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="profil-section">
        <div class="section-header">
            <i class="fas fa-map-marked-alt"></i>
            <h2>Wilayah & Batas Desa</h2>
        </div>
        <div class="content-box">
            <!-- Menampilkan deskripsi sebagai representasi wilayah jika kolom khusus belum ada -->
            <p><?= nl2br(htmlspecialchars((string)$data['deskripsi'])); ?></p>
            
            <div class="alamat-box">
                <strong>Alamat Kantor Desa:</strong> <br>
                <?= htmlspecialchars((string)$data['alamat']); ?>
            </div>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>
