<?php
include 'config/koneksi.php';
include 'includes/header.php';
include 'includes/navbar.php';

// Ambil data perangkat desa urutkan berdasarkan urutan (jika ada) atau id
$query = mysqli_query($koneksi, "SELECT * FROM perangkat_desa ORDER BY urutan ASC, id_perangkat ASC");
?>

<div class="page-header">
    <div class="container">
        <h1>Struktur Pemerintahan Desa</h1>
    </div>
</div>

<div class="container main-content">
    <div class="section-title text-center">
        <h2>Perangkat Desa</h2>
        <p>Aparatur desa yang siap melayani masyarakat.</p>
    </div>

    <?php
    if (mysqli_num_rows($query) > 0) {
        // Kelompokkan data berdasarkan urutan
        $pamong_by_urutan = [];
        while ($row = mysqli_fetch_assoc($query)) {
            $urutan = (int)$row['urutan']; // Cast to int for safety
            if (!isset($pamong_by_urutan[$urutan])) {
                $pamong_by_urutan[$urutan] = [];
            }
            $pamong_by_urutan[$urutan][] = $row;
        }

        // Urutkan grup berdasarkan key urutan
        ksort($pamong_by_urutan);
        
        echo '<div class="struktur-wrapper">';
        
        $levels = array_keys($pamong_by_urutan);
        $last_level = end($levels);

        foreach ($pamong_by_urutan as $urutan => $list_pamong) {
            echo '<div class="struktur-level" style="z-index: 2;">';
            echo '<div class="level-grid">';
            
            foreach ($list_pamong as $row) {
                ?>
                <div class="card-pamong">
                    <div class="pamong-img">
                        <?php 
                        $foto_path = "uploads/perangkat/" . $row['foto'];
                        $foto_tampil = (file_exists($foto_path) && $row['foto'] != '') ? $foto_path : "assets/img/user-placeholder.png";
                        ?>
                        <img src="<?= $foto_tampil; ?>" alt="<?= htmlspecialchars($row['nama']); ?>" onerror="this.src='https://via.placeholder.com/300x400?text=No+Image'">
                    </div>
                    <div class="pamong-info">
                        <h3><?= htmlspecialchars($row['nama']); ?></h3>
                        <span class="jabatan"><?= htmlspecialchars($row['jabatan']); ?></span>
                        <?php if(!empty($row['nip'])): ?>
                            <p class="nip">NIP: <?= htmlspecialchars($row['nip']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php
            }
            
            echo '</div>'; // End level-grid
            echo '</div>'; // End struktur-level
            
            // Tambahkan garis penghubung jika bukan level terakhir
            if ($urutan != $last_level) {
                echo '<div class="connector-line" style="width: 2px; height: 30px; background: #ccc; margin: -20px auto 10px auto; z-index: 1;"></div>';
            }
        }
        
        echo '</div>'; // End struktur-wrapper

    } else {
    ?>
        <div class="alert-info text-center">
            <p>Belum ada data perangkat desa.</p>
        </div>
    <?php } ?>
</div>

<?php
include 'includes/footer.php';
?>
